/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.util;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.MultiHashMap;
import org.apache.commons.collections.MultiMap;
import org.jopendocument.util.ExceptionUtils;

public class CollectionMap<K, V>
extends MultiHashMap {
    private final Class<? extends Collection<V>> collectionClass;
    private final Collection<V> collectionSpecimen;

    public CollectionMap() {
        this(ArrayList.class);
    }

    public CollectionMap(Class aCollectionClass) {
        this.collectionClass = aCollectionClass;
        this.collectionSpecimen = null;
    }

    public CollectionMap(Collection<V> collectionSpecimen) {
        this.collectionClass = null;
        this.collectionSpecimen = collectionSpecimen;
        if (!(collectionSpecimen instanceof Cloneable)) {
            throw new IllegalArgumentException(collectionSpecimen + " not a cloneable.");
        }
        this.collectionSpecimen.clear();
    }

    public Collection<V> getNonNull(K key) {
        Collection<V> res = (Collection<V>)super.get(key);
        return res == null ? this.createCollection(res) : res;
    }

    @Override
    protected Collection<V> createCollection(Collection coll) {
        if (this.collectionClass != null) {
            try {
                if (coll == null) {
                    return this.collectionClass.newInstance();
                }
                return this.collectionClass.getConstructor(Collection.class).newInstance(coll);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (this.collectionSpecimen != null) {
            Method m;
            try {
                m = this.collectionSpecimen.getClass().getMethod("clone", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw ExceptionUtils.createExn(IllegalStateException.class, "Cloneable w/o clone()", e);
            }
            try {
                Collection res = (Collection)m.invoke(this.collectionSpecimen, new Object[0]);
                if (coll != null) {
                    res.addAll(coll);
                }
                return res;
            }
            catch (Exception e) {
                throw ExceptionUtils.createExn(IllegalStateException.class, "clone() failed", e);
            }
        }
        return super.createCollection(coll);
    }

    public Class getCollectionClass() {
        return this.collectionClass;
    }

    public void merge(MultiMap mm) {
        for (Map.Entry entry : mm.entrySet()) {
            Collection coll = (Collection)entry.getValue();
            Collection<V> newColl = this.createCollection(coll);
            this.putAll(entry.getKey(), newColl);
        }
    }

    @Override
    public Set<Map.Entry<K, Collection<V>>> entrySet() {
        return super.entrySet();
    }

    @Override
    public Set<K> keySet() {
        return super.keySet();
    }

    @Override
    public Collection<V> values() {
        return super.values();
    }
}

