/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.util;

import java.util.Comparator;
import java.util.List;

public class CompareUtils {
    public static final int compareIntNumbers(Number n1, Number n2) {
        return CompareUtils.compareLong(n1.longValue(), n2.longValue());
    }

    public static final int compareInt(int int1, int int2) {
        if (int1 < int2) {
            return -1;
        }
        if (int1 == int2) {
            return 0;
        }
        return 1;
    }

    public static final int compareLong(long int1, long int2) {
        if (int1 < int2) {
            return -1;
        }
        if (int1 == int2) {
            return 0;
        }
        return 1;
    }

    public static final <T> Comparator<T> createComparator(final List<? extends Comparator<T>> comparators) {
        return new Comparator<T>(){

            public String toString() {
                return "CompareUtils comparator with " + comparators;
            }

            @Override
            public int compare(T o1, T o2) {
                int result = 0;
                int i = 0;
                while (i < comparators.size() && result == 0) {
                    Comparator transf = (Comparator)comparators.get(i);
                    result = transf.compare(o1, o2);
                    ++i;
                }
                return result;
            }
        };
    }

    public static final boolean equals(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }
}

