/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;

public class ExceptionUtils {
    private ExceptionUtils() {
    }

    public static <T extends Exception> T createExn(Class<T> exnClass, String msg, Throwable cause) {
        Exception instance = null;
        try {
            Constructor<T> ctor = exnClass.getConstructor(String.class);
            instance = (Exception)ctor.newInstance(msg);
        }
        catch (Exception exn) {
            throw new IllegalArgumentException(exnClass + " has no working String constructor");
        }
        instance.initCause(cause);
        return (T)instance;
    }

    public static <T extends RuntimeException> T createRTExn(Class<T> exnClass, String msg, Throwable cause) {
        if (!RuntimeException.class.isAssignableFrom(exnClass)) {
            throw new IllegalArgumentException(exnClass + " is not a Runtime exception");
        }
        return (T)((RuntimeException)ExceptionUtils.createExn(exnClass, msg, cause));
    }

    public static String getStackTrace(Throwable cause) {
        StringWriter res = new StringWriter();
        cause.printStackTrace(new PrintWriter(res));
        return res.toString();
    }
}

