/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.RepaintManager;
import org.jopendocument.renderer.ODTRenderer;

public class ImageUtilities {
    private ODTRenderer renderer;

    public ImageUtilities(ODTRenderer renderer) {
        this.renderer = renderer;
    }

    public void saveAsPng(String string) {
        try {
            File file = new File(string);
            int width = 1000;
            int height = 1000;
            BufferedImage bufferedImage = new BufferedImage(width, height, 1);
            Graphics2D g2d = bufferedImage.createGraphics();
            ImageUtilities.disableDoubleBuffering(this.renderer);
            g2d.setColor(Color.WHITE);
            g2d.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
            this.renderer.print(g2d);
            g2d.setColor(Color.red);
            g2d.drawLine(10, 10, 30, 30);
            g2d.dispose();
            ImageIO.write((RenderedImage)bufferedImage, "png", file);
            ImageUtilities.enableDoubleBuffering(this.renderer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void disableDoubleBuffering(Component c) {
        RepaintManager currentManager = RepaintManager.currentManager(c);
        currentManager.setDoubleBufferingEnabled(false);
    }

    public static void enableDoubleBuffering(Component c) {
        RepaintManager currentManager = RepaintManager.currentManager(c);
        currentManager.setDoubleBufferingEnabled(true);
    }
}

