/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.util.cache;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.logging.Level;
import org.apache.commons.collections.map.LazyMap;
import org.jopendocument.util.CollectionMap;
import org.jopendocument.util.ExceptionUtils;
import org.jopendocument.util.Log;
import org.jopendocument.util.cache.CacheResult;
import org.jopendocument.util.cache.CacheTimeOut;
import org.jopendocument.util.cache.CacheWatcher;
import org.jopendocument.util.cache.CacheWatcherFactory;
import org.jopendocument.util.cc.ITransformer;

public class ICache<K, V, D> {
    private static final Level LEVEL = Level.FINEST;
    private final LinkedHashMap<K, V> cache;
    private final Set<K> running = new HashSet<K>();
    private final int delay;
    private final int size;
    private final Timer timer;
    private final Map<K, CacheTimeOut<K>> timeoutTasks;
    private Map<D, CacheWatcher<K>> watchers;
    private final CollectionMap<K, CacheWatcher<K>> watchersByKey;

    public ICache() {
        this(60);
    }

    public ICache(int delay) {
        this(delay, -1);
    }

    public ICache(int delay, int size) {
        this.delay = delay;
        if (size == 0) {
            throw new IllegalArgumentException("0 size");
        }
        this.size = size;
        this.cache = new LinkedHashMap(size < 0 ? 64 : size);
        this.timer = new Timer(true);
        this.timeoutTasks = new HashMap<K, CacheTimeOut<K>>();
        this.watchers = null;
        this.watchersByKey = new CollectionMap(HashSet.class);
    }

    public final void setWatcherFactory(final CacheWatcherFactory<K, D> f) {
        this.watchers = LazyMap.decorate(new HashMap(), new ITransformer<D, CacheWatcher<K>>(){

            @Override
            public CacheWatcher<K> transformChecked(D input) {
                try {
                    return f.createWatcher(ICache.this, input);
                }
                catch (Exception e) {
                    throw ExceptionUtils.createExn(IllegalStateException.class, "could not create watcher for " + input, e);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final CacheResult<V> get(K sel) {
        ICache iCache = this;
        synchronized (iCache) {
            if (this.cache.containsKey(sel)) {
                this.log("IN cache", sel);
                return new CacheResult<V>(this.cache.get(sel));
            }
            if (this.isRunning(sel)) {
                this.log("RUNNING", sel);
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    return CacheResult.getInterrupted();
                }
                return this.get(sel);
            }
            this.log("NOT in cache", sel);
            return CacheResult.getNotInCache();
        }
    }

    public final synchronized void addRunning(K key) {
        this.running.add(key);
    }

    public final synchronized void removeRunning(K key) {
        this.running.remove(key);
        this.notifyAll();
    }

    public final synchronized boolean isRunning(K sel) {
        return this.running.contains(sel);
    }

    public final synchronized CacheResult<V> check(K key) {
        CacheResult<V> l = this.get(key);
        if (l.getState() == CacheResult.State.NOT_IN_CACHE) {
            this.addRunning(key);
        }
        return l;
    }

    public final synchronized void put(K sel, V res) {
        this.put(sel, res, Collections.emptySet());
    }

    public final synchronized Set<? extends CacheWatcher<K>> put(K sel, V res, Set<? extends D> data) {
        if (this.size > 0 && this.cache.size() == this.size) {
            this.clear(this.cache.keySet().iterator().next());
        }
        this.cache.put(sel, res);
        this.removeRunning(sel);
        for (D datum : data) {
            if (this.watchers == null) continue;
            CacheWatcher<K> watcher = this.watchers.get(datum);
            watcher.add(sel);
            this.watchersByKey.put((Object)sel, (Object)watcher);
        }
        CacheTimeOut<K> timeout = new CacheTimeOut<K>(this, sel);
        this.timeoutTasks.put(sel, timeout);
        this.timer.schedule(timeout, this.delay * 1000);
        return (Set)this.watchersByKey.getNonNull(sel);
    }

    public final synchronized void clear(K select) {
        this.log("clear", select);
        if (this.cache.containsKey(select)) {
            this.cache.remove(select);
            this.timeoutTasks.remove(select).cancel();
            Set keyWatchers = (Set)this.watchersByKey.getNonNull(select);
            this.watchersByKey.remove(select);
            if (keyWatchers != null) {
                for (CacheWatcher w : keyWatchers) {
                    w.remove(select);
                }
            }
        }
    }

    private final void log(String msg, Object subject) {
        if (Log.get().isLoggable(LEVEL)) {
            Log.get().log(LEVEL, String.valueOf(msg) + ": " + subject);
        }
    }

    public final synchronized int size() {
        return this.cache.size();
    }

    public final String toString() {
        return String.valueOf(this.getClass().getName()) + ", keys cached: " + this.timeoutTasks.keySet();
    }
}

