/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 2008 jOpenDocument, by ILM Informatique. All rights reserved.
 * 
 * The contents of this file are subject to the terms of the GNU General Public License Version 3
 * only ("GPL"). You may not use this file except in compliance with the License. You can obtain a
 * copy of the License at http://www.gnu.org/licenses/gpl-3.0.html See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each file.
 * 
 */

package org.jopendocument.model.table;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;

import org.jopendocument.model.style.StyleStyle;

@XmlRootElement(name = "table:table-column")
public class TableTableColumn {

    @XmlAttribute(name = "table:number-columns-repeated")
    protected String tableNumberColumnsRepeated;

    @XmlAttribute(name = "table:style-name")
    protected String tableStyleName;

    @XmlAttribute(name = "table:visibility")
    protected String tableVisibility;

    @XmlAttribute(name = "table:default-cell-style-name")
    protected String tableDefaultCellStyleName;

    private TableTable table;

    /**
     * Gets the value of the tableNumberColumnsRepeated property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public int getTableNumberColumnsRepeated() {
        if (tableNumberColumnsRepeated == null) {
            return 1;
        }
        return Integer.valueOf(tableNumberColumnsRepeated).intValue();

    }

    /**
     * Sets the value of the tableNumberColumnsRepeated property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setTableNumberColumnsRepeated(String value) {
        this.tableNumberColumnsRepeated = value;
    }

    /**
     * Gets the value of the tableStyleName property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getTableStyleName() {
        return tableStyleName;
    }

    /**
     * Sets the value of the tableStyleName property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setTableStyleName(String value) {
        this.tableStyleName = value;
    }

    /**
     * Gets the value of the tableVisibility property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getTableVisibility() {
        if (tableVisibility == null) {
            return "visible";
        }
        return tableVisibility;

    }

    /**
     * Sets the value of the tableVisibility property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setTableVisibility(String value) {
        this.tableVisibility = value;
    }

    /**
     * Gets the value of the tableDefaultCellStyleName property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getTableDefaultCellStyleName() {
        return tableDefaultCellStyleName;
    }

    /**
     * Sets the value of the tableDefaultCellStyleName property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setTableDefaultCellStyleName(String value) {
        this.tableDefaultCellStyleName = value;
    }

    /**
     * width in 10-6 m, ie micrometer
     */
    public int getWidth() {
        if (this.getTableStyleName() == null) {
            return 25000;// 2.5 cm
        }

        StyleStyle s = this.table.getSpreadsheet().getBody().getDocument().getAutomaticStyles().getColumnStyle(this.getTableStyleName());

        return s.getStyleTableColumnProperties().getColumnWidth();

    }

    public void setTable(TableTable t) {
        // setColumnStyle(t.getColumnStyle(this.tableStyleName));

        this.table = t;
    }

    /*
     * private void setColumnStyle(StyleStyle style) { this.columnStyle=style;
     * this.width=columnStyle.getWidth(); }
     */

    public StyleStyle getDefaultCellStyle() {
        StyleStyle s = table.getCellStyle(this.tableDefaultCellStyleName);
        if (s == null) {
            throw new IllegalStateException("Unable to find cell style:'" + this.tableDefaultCellStyleName + "'");
        }
        return s;
    }

    @Override
    public String toString() {

        return "TableColumn: style:" + this.getTableStyleName() + " defaultCellStyle:" + tableDefaultCellStyleName;
    }
}
