/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 2008 jOpenDocument, by ILM Informatique. All rights reserved.
 * 
 * The contents of this file are subject to the terms of the GNU
 * General Public License Version 3 only ("GPL").  
 * You may not use this file except in compliance with the License. 
 * You can obtain a copy of the License at http://www.gnu.org/licenses/gpl-3.0.html
 * See the License for the specific language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each file.
 * 
 */

package org.jopendocument.dom.template.engine;

import java.util.HashMap;
import java.util.Map;

import javax.script.ScriptEngine;

import org.jopendocument.util.ExceptionUtils;

/**
 * Contains data as regular Java objects.
 */
public class DataModel {

	private Map<String, Object> context = new HashMap<String, Object>();

	private ScriptEngine engine;

	public DataModel(ScriptEngine engine) {
		this.engine = engine;
	}

	/**
	 * @param root
	 *            the top-level Java bean or Map
	 */

	public DataModel(Map<String, Object> root, ScriptEngine engine) {

		this.context.putAll(root);
		// this.context = Ognl.createDefaultContext(null);
		// this.context.put("fmt", DataFormatter.getInstance());
		this.engine = engine;
	}

	@SuppressWarnings("unchecked")
	public DataModel(DataModel dm) {

		// final Map<String, Object> copy = new HashMap<String,
		// Object>(dm.context);
		// this.context = Ognl.addDefaultContext(Ognl.getRoot(dm.context),
		// Ognl.getClassResolver(dm.context), Ognl.getTypeConverter(dm.context),
		// Ognl.getMemberAccess(dm.context), copy);
		this.engine = dm.engine;
		this.context.putAll(dm.context);
	}

	public void putInContext(String name, Object value) {
		this.engine.put(name, value);
	}

	public Object getValue(String expression) {
		try {

			return engine.eval(expression);// O gnl.getValue(expression,
			// this.context, this.root);
		} catch (Throwable t) {
			throw ExceptionUtils.createExn(IllegalStateException.class,
					"invalid expression: \"" + expression + "\"", t);
		}
	}

}
