/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 2008 jOpenDocument, by ILM Informatique. All rights reserved.
 * 
 * The contents of this file are subject to the terms of the GNU
 * General Public License Version 3 only ("GPL").  
 * You may not use this file except in compliance with the License. 
 * You can obtain a copy of the License at http://www.gnu.org/licenses/gpl-3.0.html
 * See the License for the specific language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each file.
 * 
 */

package org.jopendocument.model.draw;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.NormalizedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;


import org.jopendocument.model.office.OfficeEvents;


/**
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "svgDesc",
    "officeEvents"
})
@XmlRootElement(name = "draw:area-circle")
public class DrawAreaCircle {

    @XmlAttribute(name = "xlink:href")
    @XmlJavaTypeAdapter(NormalizedStringAdapter.class)
    protected String xlinkHref;
    @XmlAttribute(name = "xlink:type")
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    protected String xlinkType;
    @XmlAttribute(name = "office:target-frame-name")
    @XmlJavaTypeAdapter(NormalizedStringAdapter.class)
    protected String officeTargetFrameName;
    @XmlAttribute(name = "xlink:show")
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    protected String xlinkShow;
    @XmlAttribute(name = "office:name")
    @XmlJavaTypeAdapter(NormalizedStringAdapter.class)
    protected String officeName;
    @XmlAttribute(name = "draw:nohref")
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    protected String drawNohref;
    @XmlAttribute(name = "svg:cx", required = true)
    @XmlJavaTypeAdapter(NormalizedStringAdapter.class)
    protected String svgCx;
    @XmlAttribute(name = "svg:cy", required = true)
    @XmlJavaTypeAdapter(NormalizedStringAdapter.class)
    protected String svgCy;
    @XmlAttribute(name = "svg:r", required = true)
    @XmlJavaTypeAdapter(NormalizedStringAdapter.class)
    protected String svgR;
    @XmlElement(name = "svg:desc")
    protected SvgDesc svgDesc;
    @XmlElement(name = "office:events")
    protected OfficeEvents officeEvents;

    /**
     * Gets the value of the xlinkHref property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getXlinkHref() {
        return xlinkHref;
    }

    /**
     * Sets the value of the xlinkHref property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setXlinkHref(String value) {
        this.xlinkHref = value;
    }

    /**
     * Gets the value of the xlinkType property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getXlinkType() {
        return xlinkType;
    }

    /**
     * Sets the value of the xlinkType property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setXlinkType(String value) {
        this.xlinkType = value;
    }

    /**
     * Gets the value of the officeTargetFrameName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getOfficeTargetFrameName() {
        return officeTargetFrameName;
    }

    /**
     * Sets the value of the officeTargetFrameName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setOfficeTargetFrameName(String value) {
        this.officeTargetFrameName = value;
    }

    /**
     * Gets the value of the xlinkShow property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getXlinkShow() {
        return xlinkShow;
    }

    /**
     * Sets the value of the xlinkShow property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setXlinkShow(String value) {
        this.xlinkShow = value;
    }

    /**
     * Gets the value of the officeName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getOfficeName() {
        return officeName;
    }

    /**
     * Sets the value of the officeName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setOfficeName(String value) {
        this.officeName = value;
    }

    /**
     * Gets the value of the drawNohref property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getDrawNohref() {
        return drawNohref;
    }

    /**
     * Sets the value of the drawNohref property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setDrawNohref(String value) {
        this.drawNohref = value;
    }

    /**
     * Gets the value of the svgCx property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getSvgCx() {
        return svgCx;
    }

    /**
     * Sets the value of the svgCx property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setSvgCx(String value) {
        this.svgCx = value;
    }

    /**
     * Gets the value of the svgCy property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getSvgCy() {
        return svgCy;
    }

    /**
     * Sets the value of the svgCy property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setSvgCy(String value) {
        this.svgCy = value;
    }

    /**
     * Gets the value of the svgR property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getSvgR() {
        return svgR;
    }

    /**
     * Sets the value of the svgR property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setSvgR(String value) {
        this.svgR = value;
    }

    /**
     * Gets the value of the svgDesc property.
     * 
     * @return
     *     possible object is
     *     {@link SvgDesc }
     *     
     */
    public SvgDesc getSvgDesc() {
        return svgDesc;
    }

    /**
     * Sets the value of the svgDesc property.
     * 
     * @param value
     *     allowed object is
     *     {@link SvgDesc }
     *     
     */
    public void setSvgDesc(SvgDesc value) {
        this.svgDesc = value;
    }

    /**
     * Gets the value of the officeEvents property.
     * 
     * @return
     *     possible object is
     *     {@link OfficeEvents }
     *     
     */
    public OfficeEvents getOfficeEvents() {
        return officeEvents;
    }

    /**
     * Sets the value of the officeEvents property.
     * 
     * @param value
     *     allowed object is
     *     {@link OfficeEvents }
     *     
     */
    public void setOfficeEvents(OfficeEvents value) {
        this.officeEvents = value;
    }

}
