/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 2008 jOpenDocument, by ILM Informatique. All rights reserved.
 * 
 * The contents of this file are subject to the terms of the GNU
 * General Public License Version 3 only ("GPL").  
 * You may not use this file except in compliance with the License. 
 * You can obtain a copy of the License at http://www.gnu.org/licenses/gpl-3.0.html
 * See the License for the specific language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each file.
 * 
 */

package org.jopendocument.model.text;

import java.util.ArrayList;

import org.jopendocument.model.style.StyleStyle;

public class TextSpan {

	private StyleStyle textStyle;

	private String value;

	/**
	 * Gets the value of the textStyleName property.
	 * 
	 * @return possible object is {@link String }
	 * 
	 */
	public StyleStyle getTextStyle() {
		return textStyle;
	}

	/**
	 * Sets the value of the textStyleName property.
	 * 
	 * @param value
	 *            allowed object is {@link String }
	 * 
	 */
	public void setTextStyle(StyleStyle value) {
		if (value == null) {
			throw new IllegalArgumentException("Style null");
		}
		this.textStyle = value;
	}

	/**
	 * Gets the value of the value property.
	 * 
	 * @return possible object is {@link String }
	 * 
	 */
	public String getValue() {
		return value;
	}

	/**
	 * Sets the value of the value property.
	 * 
	 * @param value allowed object is {@link String }
	 * 
	 */
	public void setValue(String value) {
		if (value == null) {
			throw new IllegalArgumentException("null argument");
		}
		this.value = value;
	}

	@Override
	public String toString() {
		return value;
	}

	public void concantValue(String string) {
		if (string == null) {
			throw new IllegalArgumentException("Style null");
		}

		if (value == null)
			this.value = string;
		else
			this.value += string;
	}

	String[] cutedValues;

	public String[] getCutedValues() {
		if (cutedValues == null) {
			ArrayList<String> list = new ArrayList<String>();
			String s = "";
			String v = this.getValue();
			for (int i = 0; i < v.length(); i++) {
				char c = v.charAt(i);
				if (c == ' ') {
					list.add(s);
					s = "";
				}

				s += c;

			}
			if (s.trim().length() > 0)
				list.add(s);
			cutedValues = list.toArray(new String[] {});
		}
		return cutedValues;
	}
}
