/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 2008 jOpenDocument, by ILM Informatique. All rights reserved.
 * 
 * The contents of this file are subject to the terms of the GNU
 * General Public License Version 3 only ("GPL").  
 * You may not use this file except in compliance with the License. 
 * You can obtain a copy of the License at http://www.gnu.org/licenses/gpl-3.0.html
 * See the License for the specific language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each file.
 * 
 */

package org.jopendocument.dom.template;


import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import javax.script.ScriptEngine;

import org.jdom.JDOMException;
import org.jopendocument.dom.ODPackage;
import org.jopendocument.dom.OOSingleXMLDocument;
import org.jopendocument.dom.template.engine.DataModel;
import org.jopendocument.dom.template.engine.Material;
import org.jopendocument.dom.template.engine.Parsed;

/**
 * Generates documents merging template and data. <br>
 * <br>
 * Sample usage:
 * 
 * <pre>
 * Template template = new Template(new FileInputStream(&quot;template.sxw&quot;));
 * Map vars = new HashMap();
 * vars.put(&quot;title&quot;, &quot;The Title&quot;);
 * //...
 * template.createDocument(vars, new FileOutputStream(&quot;document.sxw&quot;));
 * </pre>
 */
public class Template {

	protected final Parsed<ODPackage> contentTemplate;

	/**
	 * Loads a template from the specified input stream.
	 * 
	 * @param in
	 * @throws IOException
	 * @throws TemplateException
	 * @throws JDOMException
	 */
	public Template(InputStream in) throws IOException, TemplateException,
			JDOMException {
		final ODPackage contents = new ODPackage(in);
		// createDocument needs OOSingleXMLDocument
		contents.toSingle();
		this.contentTemplate = new Parsed<ODPackage>(Material.from(contents));
	}

	/**
	 * Generates a document merging template and data.
	 * 
	 * @param out
	 *            stream the document is written to
	 * @throws IOException
	 *             si erreur de zippage.
	 * @throws TemplateException
	 */
	public void createDocument(ScriptEngine engine, OutputStream out)
			throws IOException, TemplateException {
		this.execute(engine).save(out);
	}

	public OOSingleXMLDocument createDocument(ScriptEngine engine)
			throws TemplateException {
		return (OOSingleXMLDocument) execute(engine).getContent();
	}

	private ODPackage execute(ScriptEngine engine) throws TemplateException {
		return this.contentTemplate.execute(new DataModel(engine));
	}
}