/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 2008 jOpenDocument, by ILM Informatique. All rights reserved.
 * 
 * The contents of this file are subject to the terms of the GNU
 * General Public License Version 3 only ("GPL").  
 * You may not use this file except in compliance with the License. 
 * You can obtain a copy of the License at http://www.gnu.org/licenses/gpl-3.0.html
 * See the License for the specific language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each file.
 * 
 */

package org.jopendocument.model.style;

import java.awt.Color;

import org.jopendocument.util.ValueHelper;


public class StyleTableCellProperties {

    private String verticalAlign;

    private String backgroundColor;

    private String border;

    private String padding;

    private String textAlignSource;

    private String repeatContent;

    private String wrapOption;

    // Borders
    private int borderWidthLeft;

    private String borderTypeLeft; // solid, none

    private Color borderColorLeft;

    private int borderWidthRight;

    private String borderTypeRight; // solid, none

    private Color borderColorRight;

    private int borderWidthTop;

    private String borderTypeTop; // solid, none

    private Color borderColorTop;

    private int borderWidthBottom;

    private String borderTypeBottom; // solid, none

    private Color borderColorBottom;

    private boolean hasLeftBorder;
    private boolean hasRightBorder;
    private boolean hasTopBorder;
    private boolean hasBottomBorder;

    /**
     * setters
     */
    public void setVerticalAlign(String value) {
        this.verticalAlign = value;

    }

    public void setBackgroundColor(String value) {
        this.backgroundColor = value;

    }

    public void setBorder(String value) {
        if (value != null) {
            setBorderLeft(value);
            setBorderTop(value);
            setBorderRight(value);
            setBorderBottom(value);

        }

    }

    public void setPadding(String value) {
        this.padding = value;

    }

    public void setTextAlignSource(String value) {
        this.textAlignSource = value;
    }

    public void setRepeatContent(String value) {
        this.repeatContent = value;
    }

    public void setBorderLeft(String value) {
        if (value == null)
            value = "none";
        if (value.equals("none")) {
            // borderTypeLeft = value;

            return;
        }
        hasLeftBorder = true;
        String s[] = value.split(" ");
        borderWidthLeft = ValueHelper.getLenth(s[0]);
        borderTypeLeft = s[1];
        borderColorLeft = ValueHelper.getColor(s[2]);
    }

    public void setBorderRight(String value) {

        if (value == null)
            value = "none";
        if (value.equals("none")) {
            // borderTypeRight = value;

            return;
        }
        hasRightBorder = true;
        String s[] = value.split(" ");
        borderWidthRight = ValueHelper.getLenth(s[0]);
        borderTypeRight = s[1];
        borderColorRight = ValueHelper.getColor(s[2]);
        // System.err.println(s[0]+","+s[1]+","+s[2]);
    }

    public void setBorderTop(String value) {
        if (value == null)
            value = "none";
        if (value.equals("none")) {
            // borderTypeTop = value;

            return;
        }
        hasTopBorder = true;
        String s[] = value.split(" ");
        borderWidthTop = ValueHelper.getLenth(s[0]);
        borderTypeTop = s[1];
        borderColorTop = ValueHelper.getColor(s[2]);
    }

    public void setBorderBottom(String value) {
        if (value == null)
            value = "none";
        if (value.equals("none")) {
            // borderTypeBottom = value;

            return;
        }
        hasBottomBorder = true;
        String s[] = value.split(" ");
        borderWidthBottom = ValueHelper.getLenth(s[0]);
        borderTypeBottom = s[1];
        borderColorBottom = ValueHelper.getColor(s[2]);
    }

    public void setWrapOption(String value) {
        this.wrapOption = value;
    }

    /**
     * getters
     */
    public String getVerticalAlign() {
        return this.verticalAlign;
    }

    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    public String getBorder() {
        return this.border;
    }

    public String getPadding() {
        return this.padding;
    }

    public String getRepeatContent() {
        return this.repeatContent;
    }

    public String getTextAlignSource() {
        return this.textAlignSource;
    }

    public String getWrapOption() {
        return this.wrapOption;
    }

    public final Color getBorderColorBottom() {
        return borderColorBottom;
    }

    public final Color getBorderColorLeft() {
        return borderColorLeft;
    }

    public final Color getBorderColorRight() {
        return borderColorRight;
    }

    public final Color getBorderColorTop() {
        return borderColorTop;
    }

    public final String getBorderTypeBottom() {
        return borderTypeBottom;
    }

    public final String getBorderTypeLeft() {
        return borderTypeLeft;
    }

    public final String getBorderTypeRight() {
        return borderTypeRight;
    }

    public final String getBorderTypeTop() {
        return borderTypeTop;
    }

    public final int getBorderWidthBottom() {
        return borderWidthBottom;
    }

    public final int getBorderWidthLeft() {
        return borderWidthLeft;
    }

    public final int getBorderWidthRight() {
        return borderWidthRight;
    }

    public final int getBorderWidthTop() {
        return borderWidthTop;
    }

    @Override
    public String toString() {

        return "StyleTableCellProperties: border: L:" + this.borderTypeLeft + " R:" + this.borderTypeRight + " T:" + this.borderTypeTop + " B:" + this.borderTypeTop;
    }

    public final boolean hasLeftBorder() {
        return hasLeftBorder;
    }

    public final boolean hasRightBorder() {
        return hasRightBorder;
    }

    public final boolean hasTopBorder() {
        return hasTopBorder;
    }

    public final boolean hasBottomBorder() {
        return hasBottomBorder;
    }
}
