/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 2008 jOpenDocument, by ILM Informatique. All rights reserved.
 * 
 * The contents of this file are subject to the terms of the GNU
 * General Public License Version 3 only ("GPL").  
 * You may not use this file except in compliance with the License. 
 * You can obtain a copy of the License at http://www.gnu.org/licenses/gpl-3.0.html
 * See the License for the specific language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each file.
 * 
 */

package org.jopendocument.model.table;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.NormalizedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;



/**
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "tableNullDate",
    "tableIteration"
})
@XmlRootElement(name = "table:calculation-settings")
public class TableCalculationSettings {

    @XmlAttribute(name = "table:case-sensitive")
    @XmlJavaTypeAdapter(NormalizedStringAdapter.class)
    protected String tableCaseSensitive;
    @XmlAttribute(name = "table:precision-as-shown")
    @XmlJavaTypeAdapter(NormalizedStringAdapter.class)
    protected String tablePrecisionAsShown;
    @XmlAttribute(name = "table:search-criteria-must-apply-to-whole-cell")
    @XmlJavaTypeAdapter(NormalizedStringAdapter.class)
    protected String tableSearchCriteriaMustApplyToWholeCell;
    @XmlAttribute(name = "table:automatic-find-labels")
    @XmlJavaTypeAdapter(NormalizedStringAdapter.class)
    protected String tableAutomaticFindLabels;
    @XmlAttribute(name = "table:use-regular-expressions")
    @XmlJavaTypeAdapter(NormalizedStringAdapter.class)
    protected String tableUseRegularExpressions;
    @XmlAttribute(name = "table:null-year")
    @XmlJavaTypeAdapter(NormalizedStringAdapter.class)
    protected String tableNullYear;
    @XmlElement(name = "table:null-date")
    protected TableNullDate tableNullDate;
    @XmlElement(name = "table:iteration")
    protected TableIteration tableIteration;

    /**
     * Gets the value of the tableCaseSensitive property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getTableCaseSensitive() {
        if (tableCaseSensitive == null) {
            return "true";
        } else {
            return tableCaseSensitive;
        }
    }

    /**
     * Sets the value of the tableCaseSensitive property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setTableCaseSensitive(String value) {
        this.tableCaseSensitive = value;
    }

    /**
     * Gets the value of the tablePrecisionAsShown property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getTablePrecisionAsShown() {
        if (tablePrecisionAsShown == null) {
            return "false";
        } else {
            return tablePrecisionAsShown;
        }
    }

    /**
     * Sets the value of the tablePrecisionAsShown property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setTablePrecisionAsShown(String value) {
        this.tablePrecisionAsShown = value;
    }

    /**
     * Gets the value of the tableSearchCriteriaMustApplyToWholeCell property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getTableSearchCriteriaMustApplyToWholeCell() {
        if (tableSearchCriteriaMustApplyToWholeCell == null) {
            return "true";
        } else {
            return tableSearchCriteriaMustApplyToWholeCell;
        }
    }

    /**
     * Sets the value of the tableSearchCriteriaMustApplyToWholeCell property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setTableSearchCriteriaMustApplyToWholeCell(String value) {
        this.tableSearchCriteriaMustApplyToWholeCell = value;
    }

    /**
     * Gets the value of the tableAutomaticFindLabels property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getTableAutomaticFindLabels() {
        if (tableAutomaticFindLabels == null) {
            return "true";
        } else {
            return tableAutomaticFindLabels;
        }
    }

    /**
     * Sets the value of the tableAutomaticFindLabels property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setTableAutomaticFindLabels(String value) {
        this.tableAutomaticFindLabels = value;
    }

    /**
     * Gets the value of the tableUseRegularExpressions property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getTableUseRegularExpressions() {
        if (tableUseRegularExpressions == null) {
            return "true";
        } else {
            return tableUseRegularExpressions;
        }
    }

    /**
     * Sets the value of the tableUseRegularExpressions property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setTableUseRegularExpressions(String value) {
        this.tableUseRegularExpressions = value;
    }

    /**
     * Gets the value of the tableNullYear property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getTableNullYear() {
        if (tableNullYear == null) {
            return "1930";
        } else {
            return tableNullYear;
        }
    }

    /**
     * Sets the value of the tableNullYear property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setTableNullYear(String value) {
        this.tableNullYear = value;
    }

    /**
     * Gets the value of the tableNullDate property.
     * 
     * @return
     *     possible object is
     *     {@link TableNullDate }
     *     
     */
    public TableNullDate getTableNullDate() {
        return tableNullDate;
    }

    /**
     * Sets the value of the tableNullDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link TableNullDate }
     *     
     */
    public void setTableNullDate(TableNullDate value) {
        this.tableNullDate = value;
    }

    /**
     * Gets the value of the tableIteration property.
     * 
     * @return
     *     possible object is
     *     {@link TableIteration }
     *     
     */
    public TableIteration getTableIteration() {
        return tableIteration;
    }

    /**
     * Sets the value of the tableIteration property.
     * 
     * @param value
     *     allowed object is
     *     {@link TableIteration }
     *     
     */
    public void setTableIteration(TableIteration value) {
        this.tableIteration = value;
    }

}
