/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 2008 jOpenDocument, by ILM Informatique. All rights reserved.
 * 
 * The contents of this file are subject to the terms of the GNU
 * General Public License Version 3 only ("GPL").  
 * You may not use this file except in compliance with the License. 
 * You can obtain a copy of the License at http://www.gnu.org/licenses/gpl-3.0.html
 * See the License for the specific language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each file.
 * 
 */

//
// This file was generated by the JavaTM Architecture for XML Binding(JAXB) Reference
// Implementation, v2.0.5-b02-fcs
// See <a href="http://java.sun.com/xml/jaxb">http://java.sun.com/xml/jaxb</a>
// Any modifications to this file will be lost upon recompilation of the source schema.
// Generated on: 2007.05.14 at 11:03:25 PM CEST
//

package org.jopendocument.model.table;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.NormalizedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

import org.jopendocument.model.style.StyleStyle;


/**
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = { "tableTableCellOrTableCoveredTableCell" })
@XmlRootElement(name = "table:table-row")
public class TableTableRow {
    int id = 0;
    static int count = 0;
    @XmlAttribute(name = "table:number-rows-repeated")
    @XmlJavaTypeAdapter(NormalizedStringAdapter.class)
    protected int tableNumberRowsRepeated = 1;

    @XmlAttribute(name = "table:style-name")
    @XmlJavaTypeAdapter(NormalizedStringAdapter.class)
    protected String tableStyleName;

    @XmlAttribute(name = "table:visibility")
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    protected String tableVisibility;

    @XmlAttribute(name = "table:default-cell-style-name")
    @XmlJavaTypeAdapter(NormalizedStringAdapter.class)
    protected String tableDefaultCellStyleName;

    @XmlElements( { @XmlElement(name = "table:table-cell", required = true, type = TableTableCell.class),
            @XmlElement(name = "table:covered-table-cell", required = true, type = TableCoveredTableCell.class) })
    protected List<Object> tableTableCellOrTableCoveredTableCell;

    private TableTable table;

    public TableTableRow() {
        id = count;
        count++;
    }

    /**
     * Gets the value of the tableNumberRowsRepeated property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public int getTableNumberRowsRepeated() {

        return tableNumberRowsRepeated;

    }

    /**
     * Sets the value of the tableNumberRowsRepeated property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setTableNumberRowsRepeated(String value) {
        if (value != null) {
            this.tableNumberRowsRepeated = Integer.valueOf(value).intValue();
           
        }
    }

    /**
     * Gets the value of the tableStyleName property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getTableStyleName() {
        return tableStyleName;
    }

    /**
     * Sets the value of the tableStyleName property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setTableStyleName(String value) {
        this.tableStyleName = value;
    }

    public StyleStyle getStyle() {
        if(this.tableStyleName==null){
            return null;
        }
        return this.table.getRowStyle(this.tableStyleName);
    }

    /**
     * Gets the value of the tableVisibility property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getTableVisibility() {
        if (tableVisibility == null) {
            return "visible";
        }
        return tableVisibility;

    }

    /**
     * Sets the value of the tableVisibility property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setTableVisibility(String value) {
        this.tableVisibility = value;
    }

    /**
     * Gets the value of the tableDefaultCellStyleName property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getTableDefaultCellStyleName() {
        return tableDefaultCellStyleName;
    }

    /**
     * Sets the value of the tableDefaultCellStyleName property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setTableDefaultCellStyleName(String value) {
        this.tableDefaultCellStyleName = value;
    }

    /**
     * Gets the value of the tableTableCellOrTableCoveredTableCell property.
     * 
     * <p>
     * This accessor method returns a reference to the live list, not a snapshot. Therefore any
     * modification you make to the returned list will be present inside the JAXB object. This is
     * why there is not a <CODE>set</CODE> method for the tableTableCellOrTableCoveredTableCell
     * property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * 
     * <pre>
     * getTableTableCellOrTableCoveredTableCell().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list {@link TableTableCell }
     * {@link TableCoveredTableCell }
     * 
     * 
     */
    public List<Object> getTableTableCellOrTableCoveredTableCell() {
        if (tableTableCellOrTableCoveredTableCell == null) {
            tableTableCellOrTableCoveredTableCell = new ArrayList<Object>();
        }
        return this.tableTableCellOrTableCoveredTableCell;
    }

    ArrayList<TableTableCell> allCells;
    Vector<TableTableCell> cells = new Vector<TableTableCell>();

    public void addCell(TableTableCell c) {
        cells.add(c);

    }

    /**
     * Compute AllCell except the last one
     */
    void computeAllCells() {
        allCells = new ArrayList<TableTableCell>();
        for (int index = 0; index < cells.size(); index++) {
            TableTableCell c = cells.get(index);
            // for (TableTableCell c : cells) {
            final int colPosition = this.allCells.size();
            int repeated = c.getTableNumberColumnsRepeated();
            // la derniere colonne n'est repétée que dans la limite de la zone d'impression
            // sinon, on s'en coltine des milliers
            if (index == cells.size() - 1) {
                repeated = this.getTable().getPrintStopCol() - allCells.size() + 1;
            }
            for (int i = 0; i < repeated; i++) {
                TableTableColumn col = table.getColumnAtPosition(colPosition + i);
                TableTableCell cc = c.cloneCell();
                cc.setRowAndColumn(this, col);
                allCells.add(cc);
            }
        }
        // }}
        //System.err.println("Computed:" + allCells.size() + " :" + allCells);
    }

    // public List<TableTableCell> getCells() {
    // return cells;
    // }

    int cachedFromCol, cachedToCol = -1;
    TableTableCell[] cachedCellsInRange;

    public TableTableCell[] getCellsInRange(int fromCol, int toCol) {

        // System.err.println(this + " " + fromCol + " >" + toCol);
        if (allCells == null) {
            computeAllCells();
        }

        if (cachedFromCol == fromCol && cachedToCol == toCol) {
            return cachedCellsInRange;
        }

        TableTableCell[] result = new TableTableCell[toCol - fromCol + 1];

        int index = 0;
        for (int i = fromCol; i <= toCol; i++) {
            TableTableCell e = allCells.get(i);
            result[index] = e;
            index++;
        }
        cachedCellsInRange = result;
        cachedFromCol = fromCol;
        cachedToCol = toCol;

        return result;
    }

    public int getHeight() {
        // FIXME: need to be implemented !!!!!!!!
        if(this.getStyle()==null){
            return 4200; //4.2mm
        }
        return this.getStyle().getStyleTableRowProperties().getHeight();
    }

    public void setTable(TableTable t) {
        this.table = t;

    }

    public TableTable getTable() {
        return table;
    }

    @Override
    public String toString() {
        return "TableRow" + id;
    }

    public String getText() {
        String t = "";
        for (int index = 0; index < cells.size(); index++) {
            TableTableCell c = cells.get(index);
            t += c.getTextP();
        }
        return t;
    }
}
