/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 2008 jOpenDocument, by ILM Informatique. All rights reserved.
 * 
 * The contents of this file are subject to the terms of the GNU
 * General Public License Version 3 only ("GPL").  
 * You may not use this file except in compliance with the License. 
 * You can obtain a copy of the License at http://www.gnu.org/licenses/gpl-3.0.html
 * See the License for the specific language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each file.
 * 
 */

package org.jopendocument.dom;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;

/**
 * An opendocument file.
 * 
 * @author ILM Informatique 2 août 2004
 */
public class OOFileDocument extends ODPackage {

    private File file;

    public OOFileDocument(File f) throws IOException {
        super(new BufferedInputStream(new FileInputStream(f), 512 * 1024));
        this.file = f;
    }

    public OOFileDocument(Map<String, Object> files) {
        super(files);
        this.file = null;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File f) {
        final String ext = '.' + this.getContentType().getExtension();
        if (!f.getName().endsWith(ext))
            f = new File(f.getParentFile(), f.getName() + ext);
        this.file = f;
    }

    /**
     * Save the content of this package to our file, overwriting it if it exists.
     * 
     * @return the saved file.
     * @throws IOException if an error occurs while saving.
     */
    public File save() throws IOException {
        if (this.getFile().getParentFile() != null)
            this.getFile().getParentFile().mkdirs();
        // ATTN at this point, we must have read all the content of this file
        // otherwise we could save to File.createTempFile("oofd", null).deleteOnExit();
        final FileOutputStream out = new FileOutputStream(this.getFile());
        final BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(out, 512 * 1024);
        this.save(bufferedOutputStream);
        bufferedOutputStream.close();
        return this.getFile();
    }

}