/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 2008 jOpenDocument, by ILM Informatique. All rights reserved.
 * 
 * The contents of this file are subject to the terms of the GNU
 * General Public License Version 3 only ("GPL").  
 * You may not use this file except in compliance with the License. 
 * You can obtain a copy of the License at http://www.gnu.org/licenses/gpl-3.0.html
 * See the License for the specific language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each file.
 * 
 */

package org.jopendocument.model.draw;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.NormalizedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

/**
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = { "dr3DLight", "dr3DSceneOrDr3DExtrudeOrDr3DSphereOrDr3DRotateOrDr3DCube" })
@XmlRootElement(name = "dr3d:scene")
public class Dr3DScene {

	@XmlAttribute(name = "draw:style-name")
	@XmlJavaTypeAdapter(NormalizedStringAdapter.class)
	protected String drawStyleName = null;
	@XmlAttribute(name = "presentation:style-name")
	@XmlJavaTypeAdapter(NormalizedStringAdapter.class)
	protected String presentationStyleName;
	@XmlAttribute(name = "draw:text-style-name")
	@XmlJavaTypeAdapter(NormalizedStringAdapter.class)
	protected String drawTextStyleName;
	@XmlAttribute(name = "svg:x")
	@XmlJavaTypeAdapter(NormalizedStringAdapter.class)
	protected String svgX;
	@XmlAttribute(name = "svg:y")
	@XmlJavaTypeAdapter(NormalizedStringAdapter.class)
	protected String svgY;
	@XmlAttribute(name = "svg:width")
	@XmlJavaTypeAdapter(NormalizedStringAdapter.class)
	protected String svgWidth;
	@XmlAttribute(name = "svg:height")
	@XmlJavaTypeAdapter(NormalizedStringAdapter.class)
	protected String svgHeight;
	@XmlAttribute(name = "dr3d:vrp")
	@XmlJavaTypeAdapter(NormalizedStringAdapter.class)
	protected String dr3DVrp;
	@XmlAttribute(name = "dr3d:vpn")
	@XmlJavaTypeAdapter(NormalizedStringAdapter.class)
	protected String dr3DVpn;
	@XmlAttribute(name = "dr3d:vup")
	@XmlJavaTypeAdapter(NormalizedStringAdapter.class)
	protected String dr3DVup;
	@XmlAttribute(name = "dr3d:projection")
	@XmlJavaTypeAdapter(CollapsedStringAdapter.class)
	protected String dr3DProjection;
	@XmlAttribute(name = "dr3d:transform")
	@XmlJavaTypeAdapter(NormalizedStringAdapter.class)
	protected String dr3DTransform;
	@XmlAttribute(name = "dr3d:distance")
	@XmlJavaTypeAdapter(NormalizedStringAdapter.class)
	protected String dr3DDistance;
	@XmlAttribute(name = "dr3d:focal-length")
	@XmlJavaTypeAdapter(NormalizedStringAdapter.class)
	protected String dr3DFocalLength;
	@XmlAttribute(name = "dr3d:shadow-slant")
	@XmlJavaTypeAdapter(NormalizedStringAdapter.class)
	protected String dr3DShadowSlant;
	@XmlAttribute(name = "dr3d:shade-mode")
	@XmlJavaTypeAdapter(CollapsedStringAdapter.class)
	protected String dr3DShadeMode;
	@XmlAttribute(name = "dr3d:ambient-color")
	@XmlJavaTypeAdapter(NormalizedStringAdapter.class)
	protected String dr3DAmbientColor;
	@XmlAttribute(name = "dr3d:lighting-mode")
	@XmlJavaTypeAdapter(NormalizedStringAdapter.class)
	protected String dr3DLightingMode;
	@XmlAttribute(name = "draw:z-index")
	@XmlJavaTypeAdapter(NormalizedStringAdapter.class)
	protected String drawZIndex;
	@XmlAttribute(name = "draw:id")
	@XmlJavaTypeAdapter(NormalizedStringAdapter.class)
	protected String drawId;
	@XmlAttribute(name = "table:end-cell-address")
	@XmlJavaTypeAdapter(NormalizedStringAdapter.class)
	protected String tableEndCellAddress;
	@XmlAttribute(name = "table:end-x")
	@XmlJavaTypeAdapter(NormalizedStringAdapter.class)
	protected String tableEndX;
	@XmlAttribute(name = "table:end-y")
	@XmlJavaTypeAdapter(NormalizedStringAdapter.class)
	protected String tableEndY;
	@XmlAttribute(name = "table:table-background")
	@XmlJavaTypeAdapter(CollapsedStringAdapter.class)
	protected String tableTableBackground;

	Dr3DScene() {

	}

	/**
	 * Gets the value of the drawStyleName property.
	 * 
	 * @return possible object is {@link String }
	 * 
	 */
	public String getDrawStyleName() {
		return drawStyleName;
	}

	/**
	 * Sets the value of the drawStyleName property.
	 * 
	 * @param value
	 *            allowed object is {@link String }
	 * 
	 */
	public void setDrawStyleName(String value) {
		this.drawStyleName = value;
	}

	/**
	 * Gets the value of the presentationStyleName property.
	 * 
	 * @return possible object is {@link String }
	 * 
	 */
	public String getPresentationStyleName() {
		return presentationStyleName;
	}

	/**
	 * Sets the value of the presentationStyleName property.
	 * 
	 * @param value
	 *            allowed object is {@link String }
	 * 
	 */
	public void setPresentationStyleName(String value) {
		this.presentationStyleName = value;
	}

	/**
	 * Gets the value of the drawTextStyleName property.
	 * 
	 * @return possible object is {@link String }
	 * 
	 */
	public String getDrawTextStyleName() {
		return drawTextStyleName;
	}

	/**
	 * Sets the value of the drawTextStyleName property.
	 * 
	 * @param value
	 *            allowed object is {@link String }
	 * 
	 */
	public void setDrawTextStyleName(String value) {
		this.drawTextStyleName = value;
	}

	/**
	 * Gets the value of the svgX property.
	 * 
	 * @return possible object is {@link String }
	 * 
	 */
	public String getSvgX() {
		return svgX;
	}

	/**
	 * Sets the value of the svgX property.
	 * 
	 * @param value
	 *            allowed object is {@link String }
	 * 
	 */
	public void setSvgX(String value) {
		this.svgX = value;
	}

	/**
	 * Gets the value of the svgY property.
	 * 
	 * @return possible object is {@link String }
	 * 
	 */
	public String getSvgY() {
		return svgY;
	}

	/**
	 * Sets the value of the svgY property.
	 * 
	 * @param value
	 *            allowed object is {@link String }
	 * 
	 */
	public void setSvgY(String value) {
		this.svgY = value;
	}

	/**
	 * Gets the value of the svgWidth property.
	 * 
	 * @return possible object is {@link String }
	 * 
	 */
	public String getSvgWidth() {
		return svgWidth;
	}

	/**
	 * Sets the value of the svgWidth property.
	 * 
	 * @param value
	 *            allowed object is {@link String }
	 * 
	 */
	public void setSvgWidth(String value) {
		this.svgWidth = value;
	}

	/**
	 * Gets the value of the svgHeight property.
	 * 
	 * @return possible object is {@link String }
	 * 
	 */
	public String getSvgHeight() {
		return svgHeight;
	}

	/**
	 * Sets the value of the svgHeight property.
	 * 
	 * @param value
	 *            allowed object is {@link String }
	 * 
	 */
	public void setSvgHeight(String value) {
		this.svgHeight = value;
	}

	/**
	 * Gets the value of the dr3DVrp property.
	 * 
	 * @return possible object is {@link String }
	 * 
	 */
	public String getDr3DVrp() {
		return dr3DVrp;
	}

	/**
	 * Sets the value of the dr3DVrp property.
	 * 
	 * @param value
	 *            allowed object is {@link String }
	 * 
	 */
	public void setDr3DVrp(String value) {
		this.dr3DVrp = value;
	}

	/**
	 * Gets the value of the dr3DVpn property.
	 * 
	 * @return possible object is {@link String }
	 * 
	 */
	public String getDr3DVpn() {
		return dr3DVpn;
	}

	/**
	 * Sets the value of the dr3DVpn property.
	 * 
	 * @param value
	 *            allowed object is {@link String }
	 * 
	 */
	public void setDr3DVpn(String value) {
		this.dr3DVpn = value;
	}

	/**
	 * Gets the value of the dr3DVup property.
	 * 
	 * @return possible object is {@link String }
	 * 
	 */
	public String getDr3DVup() {
		return dr3DVup;
	}

	/**
	 * Sets the value of the dr3DVup property.
	 * 
	 * @param value
	 *            allowed object is {@link String }
	 * 
	 */
	public void setDr3DVup(String value) {
		this.dr3DVup = value;
	}

	/**
	 * Gets the value of the dr3DProjection property.
	 * 
	 * @return possible object is {@link String }
	 * 
	 */
	public String getDr3DProjection() {
		return dr3DProjection;
	}

	/**
	 * Sets the value of the dr3DProjection property.
	 * 
	 * @param value
	 *            allowed object is {@link String }
	 * 
	 */
	public void setDr3DProjection(String value) {
		this.dr3DProjection = value;
	}

	/**
	 * Gets the value of the dr3DTransform property.
	 * 
	 * @return possible object is {@link String }
	 * 
	 */
	public String getDr3DTransform() {
		return dr3DTransform;
	}

	/**
	 * Sets the value of the dr3DTransform property.
	 * 
	 * @param value
	 *            allowed object is {@link String }
	 * 
	 */
	public void setDr3DTransform(String value) {
		this.dr3DTransform = value;
	}

	/**
	 * Gets the value of the dr3DDistance property.
	 * 
	 * @return possible object is {@link String }
	 * 
	 */
	public String getDr3DDistance() {
		return dr3DDistance;
	}

	/**
	 * Sets the value of the dr3DDistance property.
	 * 
	 * @param value
	 *            allowed object is {@link String }
	 * 
	 */
	public void setDr3DDistance(String value) {
		this.dr3DDistance = value;
	}

	/**
	 * Gets the value of the dr3DFocalLength property.
	 * 
	 * @return possible object is {@link String }
	 * 
	 */
	public String getDr3DFocalLength() {
		return dr3DFocalLength;
	}

	/**
	 * Sets the value of the dr3DFocalLength property.
	 * 
	 * @param value
	 *            allowed object is {@link String }
	 * 
	 */
	public void setDr3DFocalLength(String value) {
		this.dr3DFocalLength = value;
	}

	/**
	 * Gets the value of the dr3DShadowSlant property.
	 * 
	 * @return possible object is {@link String }
	 * 
	 */
	public String getDr3DShadowSlant() {
		return dr3DShadowSlant;
	}

	/**
	 * Sets the value of the dr3DShadowSlant property.
	 * 
	 * @param value
	 *            allowed object is {@link String }
	 * 
	 */
	public void setDr3DShadowSlant(String value) {
		this.dr3DShadowSlant = value;
	}

	/**
	 * Gets the value of the dr3DShadeMode property.
	 * 
	 * @return possible object is {@link String }
	 * 
	 */
	public String getDr3DShadeMode() {
		return dr3DShadeMode;
	}

	/**
	 * Sets the value of the dr3DShadeMode property.
	 * 
	 * @param value
	 *            allowed object is {@link String }
	 * 
	 */
	public void setDr3DShadeMode(String value) {
		this.dr3DShadeMode = value;
	}

	/**
	 * Gets the value of the dr3DAmbientColor property.
	 * 
	 * @return possible object is {@link String }
	 * 
	 */
	public String getDr3DAmbientColor() {
		return dr3DAmbientColor;
	}

	/**
	 * Sets the value of the dr3DAmbientColor property.
	 * 
	 * @param value
	 *            allowed object is {@link String }
	 * 
	 */
	public void setDr3DAmbientColor(String value) {
		this.dr3DAmbientColor = value;
	}

	/**
	 * Gets the value of the dr3DLightingMode property.
	 * 
	 * @return possible object is {@link String }
	 * 
	 */
	public String getDr3DLightingMode() {
		return dr3DLightingMode;
	}

	/**
	 * Sets the value of the dr3DLightingMode property.
	 * 
	 * @param value
	 *            allowed object is {@link String }
	 * 
	 */
	public void setDr3DLightingMode(String value) {
		this.dr3DLightingMode = value;
	}

	/**
	 * Gets the value of the drawZIndex property.
	 * 
	 * @return possible object is {@link String }
	 * 
	 */
	public String getDrawZIndex() {
		return drawZIndex;
	}

	/**
	 * Sets the value of the drawZIndex property.
	 * 
	 * @param value
	 *            allowed object is {@link String }
	 * 
	 */
	public void setDrawZIndex(String value) {
		this.drawZIndex = value;
	}

	/**
	 * Gets the value of the drawId property.
	 * 
	 * @return possible object is {@link String }
	 * 
	 */
	public String getDrawId() {
		return drawId;
	}

	/**
	 * Sets the value of the drawId property.
	 * 
	 * @param value
	 *            allowed object is {@link String }
	 * 
	 */
	public void setDrawId(String value) {
		this.drawId = value;
	}

	/**
	 * Gets the value of the tableEndCellAddress property.
	 * 
	 * @return possible object is {@link String }
	 * 
	 */
	public String getTableEndCellAddress() {
		return tableEndCellAddress;
	}

	/**
	 * Sets the value of the tableEndCellAddress property.
	 * 
	 * @param value
	 *            allowed object is {@link String }
	 * 
	 */
	public void setTableEndCellAddress(String value) {
		this.tableEndCellAddress = value;
	}

	/**
	 * Gets the value of the tableEndX property.
	 * 
	 * @return possible object is {@link String }
	 * 
	 */
	public String getTableEndX() {
		return tableEndX;
	}

	/**
	 * Sets the value of the tableEndX property.
	 * 
	 * @param value
	 *            allowed object is {@link String }
	 * 
	 */
	public void setTableEndX(String value) {
		this.tableEndX = value;
	}

	/**
	 * Gets the value of the tableEndY property.
	 * 
	 * @return possible object is {@link String }
	 * 
	 */
	public String getTableEndY() {
		return tableEndY;
	}

	/**
	 * Sets the value of the tableEndY property.
	 * 
	 * @param value
	 *            allowed object is {@link String }
	 * 
	 */
	public void setTableEndY(String value) {
		this.tableEndY = value;
	}

	/**
	 * Gets the value of the tableTableBackground property.
	 * 
	 * @return possible object is {@link String }
	 * 
	 */
	public String getTableTableBackground() {
		return tableTableBackground;
	}

	/**
	 * Sets the value of the tableTableBackground property.
	 * 
	 * @param value
	 *            allowed object is {@link String }
	 * 
	 */
	public void setTableTableBackground(String value) {
		this.tableTableBackground = value;
	}

}
