/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 2008 jOpenDocument, by ILM Informatique. All rights reserved.
 * 
 * The contents of this file are subject to the terms of the GNU
 * General Public License Version 3 only ("GPL").  
 * You may not use this file except in compliance with the License. 
 * You can obtain a copy of the License at http://www.gnu.org/licenses/gpl-3.0.html
 * See the License for the specific language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each file.
 * 
 */

package org.jopendocument.model.draw;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.NormalizedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

import org.jopendocument.model.office.OfficeBinaryData;
import org.jopendocument.model.office.OfficeEvents;
import org.jopendocument.model.text.TextP;

/**
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = { "officeBinaryData", "officeEvents", "drawImageMap", "svgDesc", "drawContourPolygonOrDrawContourPath" })
@XmlRootElement(name = "draw:image")
public class DrawImage {

	@XmlAttribute(name = "draw:transform")
	@XmlJavaTypeAdapter(NormalizedStringAdapter.class)
	protected String drawTransform;
	@XmlAttribute(name = "draw:style-name")
	@XmlJavaTypeAdapter(NormalizedStringAdapter.class)
	protected String drawStyleName;
	@XmlAttribute(name = "presentation:style-name")
	@XmlJavaTypeAdapter(NormalizedStringAdapter.class)
	protected String presentationStyleName;
	@XmlAttribute(name = "draw:text-style-name")
	@XmlJavaTypeAdapter(NormalizedStringAdapter.class)
	protected String drawTextStyleName;
	@XmlAttribute(name = "draw:name")
	@XmlJavaTypeAdapter(NormalizedStringAdapter.class)
	protected String drawName;
	@XmlAttribute(name = "xlink:href")
	@XmlJavaTypeAdapter(NormalizedStringAdapter.class)
	protected String xlinkHref;
	@XmlAttribute(name = "xlink:type")
	@XmlJavaTypeAdapter(CollapsedStringAdapter.class)
	protected String xlinkType;
	@XmlAttribute(name = "xlink:show")
	@XmlJavaTypeAdapter(CollapsedStringAdapter.class)
	protected String xlinkShow;
	@XmlAttribute(name = "xlink:actuate")
	@XmlJavaTypeAdapter(CollapsedStringAdapter.class)
	protected String xlinkActuate;
	@XmlAttribute(name = "draw:filter-name")
	@XmlJavaTypeAdapter(NormalizedStringAdapter.class)
	protected String drawFilterName;
	@XmlAttribute(name = "text:anchor-type")
	@XmlJavaTypeAdapter(CollapsedStringAdapter.class)
	protected String textAnchorType;
	@XmlAttribute(name = "text:anchor-page-number")
	@XmlJavaTypeAdapter(NormalizedStringAdapter.class)
	protected String textAnchorPageNumber;
	@XmlAttribute(name = "svg:x")
	@XmlJavaTypeAdapter(NormalizedStringAdapter.class)
	protected String svgX;
	@XmlAttribute(name = "svg:y")
	@XmlJavaTypeAdapter(NormalizedStringAdapter.class)
	protected String svgY;
	@XmlAttribute(name = "table:end-cell-address")
	@XmlJavaTypeAdapter(NormalizedStringAdapter.class)
	protected String tableEndCellAddress;
	@XmlAttribute(name = "table:end-x")
	@XmlJavaTypeAdapter(NormalizedStringAdapter.class)
	protected String tableEndX;
	@XmlAttribute(name = "table:end-y")
	@XmlJavaTypeAdapter(NormalizedStringAdapter.class)
	protected String tableEndY;
	@XmlAttribute(name = "table:table-background")
	@XmlJavaTypeAdapter(CollapsedStringAdapter.class)
	protected String tableTableBackground;
	@XmlAttribute(name = "svg:width")
	@XmlJavaTypeAdapter(NormalizedStringAdapter.class)
	protected String svgWidth;
	@XmlAttribute(name = "svg:height")
	@XmlJavaTypeAdapter(NormalizedStringAdapter.class)
	protected String svgHeight;
	@XmlAttribute(name = "presentation:class")
	@XmlJavaTypeAdapter(CollapsedStringAdapter.class)
	protected String presentationClass;
	@XmlAttribute(name = "presentation:placeholder")
	@XmlJavaTypeAdapter(CollapsedStringAdapter.class)
	protected String presentationPlaceholder;
	@XmlAttribute(name = "presentation:user-transformed")
	@XmlJavaTypeAdapter(CollapsedStringAdapter.class)
	protected String presentationUserTransformed;
	@XmlAttribute(name = "draw:z-index")
	@XmlJavaTypeAdapter(NormalizedStringAdapter.class)
	protected String drawZIndex;
	@XmlAttribute(name = "draw:id")
	@XmlJavaTypeAdapter(NormalizedStringAdapter.class)
	protected String drawId;
	@XmlAttribute(name = "draw:layer")
	@XmlJavaTypeAdapter(NormalizedStringAdapter.class)
	protected String drawLayer;
	@XmlAttribute(name = "style:rel-width")
	@XmlJavaTypeAdapter(NormalizedStringAdapter.class)
	protected String styleRelWidth;
	@XmlAttribute(name = "style:rel-height")
	@XmlJavaTypeAdapter(NormalizedStringAdapter.class)
	protected String styleRelHeight;
	@XmlElement(name = "office:binary-data")
	protected OfficeBinaryData officeBinaryData;
	@XmlElement(name = "office:events")
	protected OfficeEvents officeEvents;
	@XmlElement(name = "draw:image-map")
	protected DrawImageMap drawImageMap;
	@XmlElement(name = "svg:desc")
	protected SvgDesc svgDesc;
	@XmlElements( { @XmlElement(name = "draw:contour-polygon", type = DrawContourPolygon.class), @XmlElement(name = "draw:contour-path", type = DrawContourPath.class) })
	protected List<Object> drawContourPolygonOrDrawContourPath;
	private TextP textp;

	/**
	 * Gets the value of the drawTransform property.
	 * 
	 * @return possible object is {@link String }
	 * 
	 */
	public String getDrawTransform() {
		return drawTransform;
	}

	/**
	 * Sets the value of the drawTransform property.
	 * 
	 * @param value
	 *            allowed object is {@link String }
	 * 
	 */
	public void setDrawTransform(String value) {
		this.drawTransform = value;
	}

	/**
	 * Gets the value of the drawStyleName property.
	 * 
	 * @return possible object is {@link String }
	 * 
	 */
	public String getDrawStyleName() {
		return drawStyleName;
	}

	/**
	 * Sets the value of the drawStyleName property.
	 * 
	 * @param value
	 *            allowed object is {@link String }
	 * 
	 */
	public void setDrawStyleName(String value) {
		this.drawStyleName = value;
	}

	/**
	 * Gets the value of the presentationStyleName property.
	 * 
	 * @return possible object is {@link String }
	 * 
	 */
	public String getPresentationStyleName() {
		return presentationStyleName;
	}

	/**
	 * Sets the value of the presentationStyleName property.
	 * 
	 * @param value
	 *            allowed object is {@link String }
	 * 
	 */
	public void setPresentationStyleName(String value) {
		this.presentationStyleName = value;
	}

	/**
	 * Gets the value of the drawTextStyleName property.
	 * 
	 * @return possible object is {@link String }
	 * 
	 */
	public String getDrawTextStyleName() {
		return drawTextStyleName;
	}

	/**
	 * Sets the value of the drawTextStyleName property.
	 * 
	 * @param value
	 *            allowed object is {@link String }
	 * 
	 */
	public void setDrawTextStyleName(String value) {
		this.drawTextStyleName = value;
	}

	/**
	 * Gets the value of the drawName property.
	 * 
	 * @return possible object is {@link String }
	 * 
	 */
	public String getDrawName() {
		return drawName;
	}

	/**
	 * Sets the value of the drawName property.
	 * 
	 * @param value
	 *            allowed object is {@link String }
	 * 
	 */
	public void setDrawName(String value) {
		this.drawName = value;
	}

	/**
	 * Gets the value of the xlinkHref property.
	 * 
	 * @return possible object is {@link String }
	 * 
	 */
	public String getXlinkHref() {
		return xlinkHref;
	}

	/**
	 * Sets the value of the xlinkHref property.
	 * 
	 * @param value
	 *            allowed object is {@link String }
	 * 
	 */
	public void setXlinkHref(String value) {
		this.xlinkHref = value;
	}

	/**
	 * Gets the value of the xlinkType property.
	 * 
	 * @return possible object is {@link String }
	 * 
	 */
	public String getXlinkType() {
		return xlinkType;
	}

	/**
	 * Sets the value of the xlinkType property.
	 * 
	 * @param value
	 *            allowed object is {@link String }
	 * 
	 */
	public void setXlinkType(String value) {
		this.xlinkType = value;
	}

	/**
	 * Gets the value of the xlinkShow property.
	 * 
	 * @return possible object is {@link String }
	 * 
	 */
	public String getXlinkShow() {
		return xlinkShow;
	}

	/**
	 * Sets the value of the xlinkShow property.
	 * 
	 * @param value
	 *            allowed object is {@link String }
	 * 
	 */
	public void setXlinkShow(String value) {
		this.xlinkShow = value;
	}

	/**
	 * Gets the value of the xlinkActuate property.
	 * 
	 * @return possible object is {@link String }
	 * 
	 */
	public String getXlinkActuate() {
		return xlinkActuate;
	}

	/**
	 * Sets the value of the xlinkActuate property.
	 * 
	 * @param value
	 *            allowed object is {@link String }
	 * 
	 */
	public void setXlinkActuate(String value) {
		this.xlinkActuate = value;
	}

	/**
	 * Gets the value of the drawFilterName property.
	 * 
	 * @return possible object is {@link String }
	 * 
	 */
	public String getDrawFilterName() {
		return drawFilterName;
	}

	/**
	 * Sets the value of the drawFilterName property.
	 * 
	 * @param value
	 *            allowed object is {@link String }
	 * 
	 */
	public void setDrawFilterName(String value) {
		this.drawFilterName = value;
	}

	/**
	 * Gets the value of the textAnchorType property.
	 * 
	 * @return possible object is {@link String }
	 * 
	 */
	public String getTextAnchorType() {
		return textAnchorType;
	}

	/**
	 * Sets the value of the textAnchorType property.
	 * 
	 * @param value
	 *            allowed object is {@link String }
	 * 
	 */
	public void setTextAnchorType(String value) {
		this.textAnchorType = value;
	}

	/**
	 * Gets the value of the textAnchorPageNumber property.
	 * 
	 * @return possible object is {@link String }
	 * 
	 */
	public String getTextAnchorPageNumber() {
		return textAnchorPageNumber;
	}

	/**
	 * Sets the value of the textAnchorPageNumber property.
	 * 
	 * @param value
	 *            allowed object is {@link String }
	 * 
	 */
	public void setTextAnchorPageNumber(String value) {
		this.textAnchorPageNumber = value;
	}

	/**
	 * Gets the value of the svgX property.
	 * 
	 * @return possible object is {@link String }
	 * 
	 */
	public String getSvgX() {
		return svgX;
	}

	/**
	 * Sets the value of the svgX property.
	 * 
	 * @param value
	 *            allowed object is {@link String }
	 * 
	 */
	public void setSvgX(String value) {
		this.svgX = value;
	}

	/**
	 * Gets the value of the svgY property.
	 * 
	 * @return possible object is {@link String }
	 * 
	 */
	public String getSvgY() {
		return svgY;
	}

	/**
	 * Sets the value of the svgY property.
	 * 
	 * @param value
	 *            allowed object is {@link String }
	 * 
	 */
	public void setSvgY(String value) {
		this.svgY = value;
	}

	/**
	 * Gets the value of the tableEndCellAddress property.
	 * 
	 * @return possible object is {@link String }
	 * 
	 */
	public String getTableEndCellAddress() {
		return tableEndCellAddress;
	}

	/**
	 * Sets the value of the tableEndCellAddress property.
	 * 
	 * @param value
	 *            allowed object is {@link String }
	 * 
	 */
	public void setTableEndCellAddress(String value) {
		this.tableEndCellAddress = value;
	}

	/**
	 * Gets the value of the tableEndX property.
	 * 
	 * @return possible object is {@link String }
	 * 
	 */
	public String getTableEndX() {
		return tableEndX;
	}

	/**
	 * Sets the value of the tableEndX property.
	 * 
	 * @param value
	 *            allowed object is {@link String }
	 * 
	 */
	public void setTableEndX(String value) {
		this.tableEndX = value;
	}

	/**
	 * Gets the value of the tableEndY property.
	 * 
	 * @return possible object is {@link String }
	 * 
	 */
	public String getTableEndY() {
		return tableEndY;
	}

	/**
	 * Sets the value of the tableEndY property.
	 * 
	 * @param value
	 *            allowed object is {@link String }
	 * 
	 */
	public void setTableEndY(String value) {
		this.tableEndY = value;
	}

	/**
	 * Gets the value of the tableTableBackground property.
	 * 
	 * @return possible object is {@link String }
	 * 
	 */
	public String getTableTableBackground() {
		return tableTableBackground;
	}

	/**
	 * Sets the value of the tableTableBackground property.
	 * 
	 * @param value
	 *            allowed object is {@link String }
	 * 
	 */
	public void setTableTableBackground(String value) {
		this.tableTableBackground = value;
	}

	/**
	 * Gets the value of the svgWidth property.
	 * 
	 * @return possible object is {@link String }
	 * 
	 */
	public String getSvgWidth() {
		return svgWidth;
	}

	/**
	 * Sets the value of the svgWidth property.
	 * 
	 * @param value
	 *            allowed object is {@link String }
	 * 
	 */
	public void setSvgWidth(String value) {
		this.svgWidth = value;
	}

	/**
	 * Gets the value of the svgHeight property.
	 * 
	 * @return possible object is {@link String }
	 * 
	 */
	public String getSvgHeight() {
		return svgHeight;
	}

	/**
	 * Sets the value of the svgHeight property.
	 * 
	 * @param value
	 *            allowed object is {@link String }
	 * 
	 */
	public void setSvgHeight(String value) {
		this.svgHeight = value;
	}

	/**
	 * Gets the value of the presentationClass property.
	 * 
	 * @return possible object is {@link String }
	 * 
	 */
	public String getPresentationClass() {
		return presentationClass;
	}

	/**
	 * Sets the value of the presentationClass property.
	 * 
	 * @param value
	 *            allowed object is {@link String }
	 * 
	 */
	public void setPresentationClass(String value) {
		this.presentationClass = value;
	}

	/**
	 * Gets the value of the presentationPlaceholder property.
	 * 
	 * @return possible object is {@link String }
	 * 
	 */
	public String getPresentationPlaceholder() {
		return presentationPlaceholder;
	}

	/**
	 * Sets the value of the presentationPlaceholder property.
	 * 
	 * @param value
	 *            allowed object is {@link String }
	 * 
	 */
	public void setPresentationPlaceholder(String value) {
		this.presentationPlaceholder = value;
	}

	/**
	 * Gets the value of the presentationUserTransformed property.
	 * 
	 * @return possible object is {@link String }
	 * 
	 */
	public String getPresentationUserTransformed() {
		return presentationUserTransformed;
	}

	/**
	 * Sets the value of the presentationUserTransformed property.
	 * 
	 * @param value
	 *            allowed object is {@link String }
	 * 
	 */
	public void setPresentationUserTransformed(String value) {
		this.presentationUserTransformed = value;
	}

	/**
	 * Gets the value of the drawZIndex property.
	 * 
	 * @return possible object is {@link String }
	 * 
	 */
	public String getDrawZIndex() {
		return drawZIndex;
	}

	/**
	 * Sets the value of the drawZIndex property.
	 * 
	 * @param value
	 *            allowed object is {@link String }
	 * 
	 */
	public void setDrawZIndex(String value) {
		this.drawZIndex = value;
	}

	/**
	 * Gets the value of the drawId property.
	 * 
	 * @return possible object is {@link String }
	 * 
	 */
	public String getDrawId() {
		return drawId;
	}

	/**
	 * Sets the value of the drawId property.
	 * 
	 * @param value
	 *            allowed object is {@link String }
	 * 
	 */
	public void setDrawId(String value) {
		this.drawId = value;
	}

	/**
	 * Gets the value of the drawLayer property.
	 * 
	 * @return possible object is {@link String }
	 * 
	 */
	public String getDrawLayer() {
		return drawLayer;
	}

	/**
	 * Sets the value of the drawLayer property.
	 * 
	 * @param value
	 *            allowed object is {@link String }
	 * 
	 */
	public void setDrawLayer(String value) {
		this.drawLayer = value;
	}

	/**
	 * Gets the value of the styleRelWidth property.
	 * 
	 * @return possible object is {@link String }
	 * 
	 */
	public String getStyleRelWidth() {
		return styleRelWidth;
	}

	/**
	 * Sets the value of the styleRelWidth property.
	 * 
	 * @param value
	 *            allowed object is {@link String }
	 * 
	 */
	public void setStyleRelWidth(String value) {
		this.styleRelWidth = value;
	}

	/**
	 * Gets the value of the styleRelHeight property.
	 * 
	 * @return possible object is {@link String }
	 * 
	 */
	public String getStyleRelHeight() {
		return styleRelHeight;
	}

	/**
	 * Sets the value of the styleRelHeight property.
	 * 
	 * @param value
	 *            allowed object is {@link String }
	 * 
	 */
	public void setStyleRelHeight(String value) {
		this.styleRelHeight = value;
	}

	/**
	 * Gets the value of the officeBinaryData property.
	 * 
	 * @return possible object is {@link OfficeBinaryData }
	 * 
	 */
	public OfficeBinaryData getOfficeBinaryData() {
		return officeBinaryData;
	}

	/**
	 * Sets the value of the officeBinaryData property.
	 * 
	 * @param value
	 *            allowed object is {@link OfficeBinaryData }
	 * 
	 */
	public void setOfficeBinaryData(OfficeBinaryData value) {
		this.officeBinaryData = value;
	}

	/**
	 * Gets the value of the officeEvents property.
	 * 
	 * @return possible object is {@link OfficeEvents }
	 * 
	 */
	public OfficeEvents getOfficeEvents() {
		return officeEvents;
	}

	/**
	 * Sets the value of the officeEvents property.
	 * 
	 * @param value
	 *            allowed object is {@link OfficeEvents }
	 * 
	 */
	public void setOfficeEvents(OfficeEvents value) {
		this.officeEvents = value;
	}

	/**
	 * Gets the value of the drawImageMap property.
	 * 
	 * @return possible object is {@link DrawImageMap }
	 * 
	 */
	public DrawImageMap getDrawImageMap() {
		return drawImageMap;
	}

	/**
	 * Sets the value of the drawImageMap property.
	 * 
	 * @param value
	 *            allowed object is {@link DrawImageMap }
	 * 
	 */
	public void setDrawImageMap(DrawImageMap value) {
		this.drawImageMap = value;
	}

	/**
	 * Gets the value of the svgDesc property.
	 * 
	 * @return possible object is {@link SvgDesc }
	 * 
	 */
	public SvgDesc getSvgDesc() {
		return svgDesc;
	}

	/**
	 * Sets the value of the svgDesc property.
	 * 
	 * @param value
	 *            allowed object is {@link SvgDesc }
	 * 
	 */
	public void setSvgDesc(SvgDesc value) {
		this.svgDesc = value;
	}

	/**
	 * Gets the value of the drawContourPolygonOrDrawContourPath property.
	 * 
	 * <p>
	 * This accessor method returns a reference to the live list, not a
	 * snapshot. Therefore any modification you make to the returned list will
	 * be present inside the JAXB object. This is why there is not a
	 * <CODE>set</CODE> method for the drawContourPolygonOrDrawContourPath
	 * property.
	 * 
	 * <p>
	 * For example, to add a new item, do as follows:
	 * 
	 * <pre>
	 * getDrawContourPolygonOrDrawContourPath().add(newItem);
	 * </pre>
	 * 
	 * 
	 * <p>
	 * Objects of the following type(s) are allowed in the list
	 * {@link DrawContourPolygon } {@link DrawContourPath }
	 * 
	 * 
	 */
	public List<Object> getDrawContourPolygonOrDrawContourPath() {
		if (drawContourPolygonOrDrawContourPath == null) {
			drawContourPolygonOrDrawContourPath = new ArrayList<Object>();
		}
		return this.drawContourPolygonOrDrawContourPath;
	}

	public void setTextP(TextP p) {
		this.textp = p;

	}

	public TextP getTextp() {
		return textp;
	}
}
