/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 2008 jOpenDocument, by ILM Informatique. All rights reserved.
 * 
 * The contents of this file are subject to the terms of the GNU
 * General Public License Version 3 only ("GPL").  
 * You may not use this file except in compliance with the License. 
 * You can obtain a copy of the License at http://www.gnu.org/licenses/gpl-3.0.html
 * See the License for the specific language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each file.
 * 
 */

package org.jopendocument.dom.spreadsheet;

import org.jopendocument.dom.NS;

import java.awt.Point;

import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

import junit.framework.TestCase;

public class SheetTest extends TestCase {

    static final DefaultTableModel tm;
    static {
        tm = new DefaultTableModel();
        tm.addColumn("col1");
        tm.addColumn("col2");
        tm.addColumn("col3");

        tm.addRow(new Object[] { "un1", new Float(-5.32), new Integer(123) });
    }

    private Sheet sheet;

    protected void setUp() throws Exception {
        this.sheet = SpreadSheet.createEmpty(tm, NS.getOOo()).getSheet(0);
    }

    protected void tearDown() throws Exception {
        this.sheet = null;
    }

    /*
     * Test method for 'org.jopendocument.dom.spreadsheet.Sheet.setValueAt(Object, int, int)'
     */
    public void testSetValueAt() {
        assertEquals("col1", this.sheet.getValueAt(0, 0));
        this.sheet.setValueAt("test", 0, 0);
        assertEquals("test", this.sheet.getValueAt(0, 0));

    }

    /*
     * Test method for 'org.jopendocument.dom.spreadsheet.Sheet.getImmutableCellAt(int, int)'
     */
    public void testGetImmutableCellAtIntInt() {

    }

    /*
     * Test method for 'org.jopendocument.dom.spreadsheet.Sheet.getImmutableCellAt(String)'
     */
    public void testGetImmutableCellAtString() {

    }

    /*
     * Test method for 'org.jopendocument.dom.spreadsheet.Sheet.getValueAt(int, int)'
     */
    public void testGetValueAtIntInt() {
        assertEquals(new Float(123), this.sheet.getValueAt(2, 1));
    }

    /*
     * Test method for 'org.jopendocument.dom.spreadsheet.Sheet.getValueAt(String)'
     */
    public void testGetValueAtString() {
        // oo ne connait les int seulement les float
        assertEquals(new Float(123), this.sheet.getValueAt("C2"));
        assertFalse(new Integer(123).equals(this.sheet.getValueAt("C2")));
    }

    /*
     * Test method for 'org.jopendocument.dom.spreadsheet.Sheet.getRowCount()'
     */
    public void testGetRowCount() {
        // col labels + 1 row
        assertEquals(2, this.sheet.getRowCount());
    }

    /*
     * Test method for 'org.jopendocument.dom.spreadsheet.Sheet.getColumnCount()'
     */
    public void testGetColumnCount() {
        assertEquals(3, this.sheet.getColumnCount());
    }

    /*
     * Test method for 'org.jopendocument.dom.spreadsheet.Sheet.setColumnCount(int)'
     */
    public void testSetColumnCountInt() {
        final int newSize = this.sheet.getColumnCount() + 5;
        try {
            this.sheet.setValueAt("test", newSize - 1, 0);
            fail("should have thrown IndexOutOfBoundsException");
        } catch (IndexOutOfBoundsException exn) {
            // normal
        }
        this.sheet.setColumnCount(newSize);
        this.sheet.setValueAt("test", newSize - 1, 0);
    }

    /*
     * Test method for 'org.jopendocument.dom.spreadsheet.Sheet.ensureColumnCount(int)'
     */
    public void testEnsureColumnCount() {
        final int before = this.sheet.getColumnCount();
        final int newSize = before - 2;
        this.sheet.ensureColumnCount(newSize);
        assertEquals(before, this.sheet.getColumnCount());
    }

    /*
     * Test method for 'org.jopendocument.dom.spreadsheet.Sheet.setColumnCount(int, int)'
     */
    public void testSetColumnCountIntInt() {

    }

    /*
     * Test method for 'org.jopendocument.dom.spreadsheet.Sheet.ensureRowCount(int)'
     */
    public void testEnsureRowCount() {

    }

    /*
     * Test method for 'org.jopendocument.dom.spreadsheet.Sheet.setRowCount(int)'
     */
    public void testSetRowCountInt() {

    }

    /*
     * Test method for 'org.jopendocument.dom.spreadsheet.Sheet.setRowCount(int, int)'
     */
    public void testSetRowCountIntInt() {

    }

    /*
     * Test method for 'org.jopendocument.dom.spreadsheet.Sheet.getTableModel(int, int)'
     */
    public void testGetTableModel() {
        TableModel t = this.sheet.getTableModel(1, 0);
        assertEquals(tm.getColumnCount() - 1, t.getColumnCount());
        // +1: col labels
        assertEquals(tm.getRowCount() + 1, t.getRowCount());
        assertEquals(new Float(-5.32), t.getValueAt(1, 0));
    }

    /*
     * Test method for 'org.jopendocument.dom.spreadsheet.Sheet.getMutableTableModel(int, int)'
     */
    public void testGetMutableTableModel() {
        this.sheet.getMutableTableModel(1, 0).setValueAt("test", 0, 1);
        assertEquals("test", this.sheet.getCellAt("C1").getValue());
    }

    /*
     * Test method for 'org.jopendocument.dom.spreadsheet.Sheet.merge(TableModel, int, int)'
     */
    public void testMerge() {

    }

    public void testIsCellRef() {
        assertTrue(Sheet.isCellRef("A23"));
        assertFalse(Sheet.isCellRef("A23A"));
        assertFalse(Sheet.isCellRef("test"));
        assertFalse(Sheet.isCellRef("23"));
    }

    public void testResolve() {
        assertEquals(Sheet.resolve("AA34"), new Point(26, 33));
    }

    public void testToInt() {
        assertEquals(0, Sheet.toInt("A"));
        assertEquals(26, Sheet.toInt("AA"));
        assertEquals(77, Sheet.toInt("BZ"));
    }

}
