/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 2008 jOpenDocument, by ILM Informatique. All rights reserved.
 * 
 * The contents of this file are subject to the terms of the GNU
 * General Public License Version 3 only ("GPL").  
 * You may not use this file except in compliance with the License. 
 * You can obtain a copy of the License at http://www.gnu.org/licenses/gpl-3.0.html
 * See the License for the specific language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each file.
 * 
 */

package org.jopendocument.model.style;

import java.awt.Color;

import org.jopendocument.util.ValueHelper;


public class StylePageLayoutProperties {

    private int marginTop;
    private int marginBottom;
    private int marginLeft;
    private int marginRight;
    private String shadow;
    private Color backgroundColor;
    private String scaleTo;
    private String tableCentering;
    private String writingMode;
    private int pageWidth;
    private int pageHeight;

    public void setMarginTop(String value) {
        if (value == null) {
            value = "2.0cm";
        }
        marginTop = ValueHelper.getLenth(value);
    }

    public int getMarginTop() {

        return marginTop;
    }

    public void setMarginBottom(String value) {
        if (value == null) {
            value = "2.0cm";
        }
        marginBottom = ValueHelper.getLenth(value);
    }

    public int getMarginBottom() {
        return marginBottom;
    }

    public void setMarginLeft(String value) {
        if (value == null) {
            value = "2.0cm";
        }
        marginLeft = ValueHelper.getLenth(value);
    }

    public int getMarginLeft() {
        return marginLeft;
    }

    public void setMarginRight(String value) {
        if (value == null) {
            value = "2.0cm";
        }
        marginRight = ValueHelper.getLenth(value);
    }

    public int getMarginRight() {
        return marginRight;
    }

    public void setShadow(String value) {
        shadow = value;
    }

    public void setBackgroundColor(String value) {
        if (value == null)
            backgroundColor = Color.white;
        else
            backgroundColor = ValueHelper.getColor(value);
    }

    public Color getBackgroundColor() {
        return backgroundColor;
    }

    public void setScaleTo(String value) {
        scaleTo = value;
    }

    public String getScaleTo() {
        return scaleTo;
    }

    public void setTableCentering(String value) {
        tableCentering = value;
    }

    public String getTableCentering() {
        return tableCentering;
    }

    public void setWritingMode(String value) {
        writingMode = value;
    }

    public String getWritingMode() {
        return writingMode;
    }

    public void setPageWidth(String value) {
        if (value == null) {
            value = "21.0cm";
            System.err.println("StylePageLayoutProperties: Assuming Page Format A4: Width:  " + value);
        }
        this.pageWidth = ValueHelper.getLenth(value);
    }

    public int getPageWidth() {
        return pageWidth;
    }

    public void setPageHeight(String value) {
        if (value == null) {
            value = "29.7cm";
            System.err.println("StylePageLayoutProperties: Assuming Page Format A4: Height: " + value);
        }
        this.pageHeight = ValueHelper.getLenth(value);
    }

    public int getPageHeight() {
        return pageHeight;
    }
}
