/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 2008 jOpenDocument, by ILM Informatique. All rights reserved.
 * 
 * The contents of this file are subject to the terms of the GNU
 * General Public License Version 3 only ("GPL").  
 * You may not use this file except in compliance with the License. 
 * You can obtain a copy of the License at http://www.gnu.org/licenses/gpl-3.0.html
 * See the License for the specific language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each file.
 * 
 */

package org.jopendocument.model.style;

import java.awt.Color;
import java.awt.Font;

import org.jopendocument.util.ValueHelper;


public class StyleTextProperties {

    private String fontName;

    private String fontSize;

    private String fontWeight;

    public void setFontName(String value) {
        fontName = value;
    }

    public void setFontSize(String value) {
        fontSize = value;
    }

    public void setFontWeight(String value) {
        fontWeight = value;
    }

    public String getFontName() {
        return fontName;
    }

    public String getFontSize() {
        return fontSize;
    }

    public String getFontWeight() {
        return fontWeight;
    }

    Font lastFont;
    double lastResizeFactor;

    private Color color;

    public Font getFont(double resizeFactor) {
        if (this.lastResizeFactor == resizeFactor) {
            return lastFont;
        }
        String currentFontName = this.fontName;

        int fonttype = Font.PLAIN;
        if (fontWeight != null && fontWeight.equals("bold")) {
            fonttype = Font.BOLD;
        }
        if (fontSize == null) {
            fontSize = "10pt";
            System.err.println("Assert default font size: 10");
        }
        String substring = fontSize.substring(0, fontSize.length() - 2);
        int fSize = Integer.valueOf(substring).intValue();
        if (currentFontName.equalsIgnoreCase("Times")) {
            currentFontName = "Times New Roman";
        }

        if (currentFontName == null) {
            throw new IllegalStateException("font name null!!");
        }
        Font font = new Font(currentFontName, fonttype, (int) ((fSize * 360) / resizeFactor));
        // System.err.println("StyleTextProperties.getFont():"+font.getFontName());
        // System.err.println("StyleTextProperties.getFont() " + currentFontName + " font size:" +
        // this.fontSize + " " + (int) ((fSize * 360) / resizeFactor));
        lastFont = font;
        lastResizeFactor = resizeFactor;
        return font;
    }

    @Override
    public String toString() {
        return "StyleTextProperty:" + fontName + " " + fontSize + " " + fontWeight;
    }

    public void setColor(String value) {
        if (value != null) {

            this.color = ValueHelper.getColor(value);
           
        }
    }

    public Color getColor() {
        return color;
    }

    public void setColor(Color fontColor) {
        this.color = fontColor;

    }
}
