/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 2008 jOpenDocument, by ILM Informatique. All rights reserved.
 * 
 * The contents of this file are subject to the terms of the GNU
 * General Public License Version 3 only ("GPL").  
 * You may not use this file except in compliance with the License. 
 * You can obtain a copy of the License at http://www.gnu.org/licenses/gpl-3.0.html
 * See the License for the specific language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each file.
 * 
 */

//
// This file was generated by the JavaTM Architecture for XML Binding(JAXB) Reference
// Implementation, v2.0.5-b02-fcs
// See <a href="http://java.sun.com/xml/jaxb">http://java.sun.com/xml/jaxb</a>
// Any modifications to this file will be lost upon recompilation of the source schema.
// Generated on: 2007.05.14 at 11:03:25 PM CEST
//

package org.jopendocument.model.table;

import java.util.List;
import java.util.Vector;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;

import org.jopendocument.model.draw.DrawFrame;
import org.jopendocument.model.draw.DrawImage;
import org.jopendocument.model.office.OfficeAnnotation;
import org.jopendocument.model.style.StyleStyle;
import org.jopendocument.model.text.TextP;

public class TableTableCell {

	@XmlAttribute(name = "table:number-columns-repeated")
	protected int tableNumberColumnsRepeated = 1;

	@XmlAttribute(name = "table:number-rows-spanned")
	protected int tableNumberRowsSpanned = 1;

	@XmlAttribute(name = "table:number-columns-spanned")
	protected int tableNumberColumnsSpanned = 1;

	@XmlAttribute(name = "table:style-name")
	protected String tableStyleName;

	@XmlAttribute(name = "table:validation-name")
	protected String tableValidationName;

	@XmlAttribute(name = "table:formula")
	protected String tableFormula;

	@XmlAttribute(name = "table:number-matrix-rows-spanned")
	protected String tableNumberMatrixRowsSpanned;

	@XmlAttribute(name = "table:number-matrix-columns-spanned")
	protected String tableNumberMatrixColumnsSpanned;

	@XmlAttribute(name = "table:value-type")
	protected String tableValueType;

	@XmlAttribute(name = "table:value")
	protected String tableValue;

	@XmlAttribute(name = "table:date-value")
	protected String tableDateValue;

	@XmlAttribute(name = "table:time-value")
	protected String tableTimeValue;

	@XmlAttribute(name = "table:boolean-value")
	protected String tableBooleanValue;

	@XmlAttribute(name = "table:string-value")
	protected String tableStringValue;

	@XmlAttribute(name = "table:currency")
	protected String tableCurrency;

	@XmlAttribute(name = "table:protected")
	protected String tableProtected;

	@XmlElement(name = "table:cell-range-source")
	protected TableCellRangeSource tableCellRangeSource;

	@XmlElement(name = "table:detective")
	protected TableDetective tableDetective;

	@XmlElement(name = "office:annotation")
	protected OfficeAnnotation officeAnnotation;

	private TextP textP;

	protected TableTableRow row;
	private TableTableColumn column;
	private boolean covered;

	private DrawImage drawImage;

	private List<DrawFrame> drawFrames;

	private StyleStyle cellStyle;

	/**
	 * Gets the value of the tableNumberColumnsRepeated property.
	 * 
	 */
	public int getTableNumberColumnsRepeated() {
		return tableNumberColumnsRepeated;
	}

	/**
	 * Sets the value of the tableNumberColumnsRepeated property.
	 * 
	 * @param value
	 *            allowed object is {@link String }
	 * 
	 */
	public void setTableNumberColumnsRepeated(String value) {
		if (value != null)
			this.tableNumberColumnsRepeated = Integer.valueOf(value);
	}

	/**
	 * Gets the value of the tableNumberRowsSpanned property.
	 * 
	 * @return possible object is {@link String }
	 * 
	 */
	public int getTableNumberRowsSpanned() {

		return tableNumberRowsSpanned;

	}

	/**
	 * Sets the value of the tableNumberRowsSpanned property.
	 * 
	 * @param value
	 *            allowed object is {@link String }
	 * 
	 */
	public void setTableNumberRowsSpanned(String value) {
		if (value != null)

			this.tableNumberRowsSpanned = Integer.valueOf(value);
	}

	/**
	 * Gets the value of the tableNumberColumnsSpanned property.
	 * 
	 * @return possible object is {@link String }
	 * 
	 */
	public int getTableNumberColumnsSpanned() {

		return tableNumberColumnsSpanned;

	}

	/**
	 * Sets the value of the tableNumberColumnsSpanned property.
	 * 
	 * @param value
	 *            allowed object is {@link String }
	 * 
	 */
	public void setTableNumberColumnsSpanned(String value) {
		if (value != null)

			this.tableNumberColumnsSpanned = Integer.valueOf(value);
	}

	/**
	 * Gets the value of the tableStyleName property.
	 * 
	 * @return possible object is {@link String }
	 * 
	 */
	public String getStyleName() {
		return tableStyleName;
	}

	/**
	 * Sets the value of the tableStyleName property.
	 * 
	 * @param value
	 *            allowed object is {@link String }
	 * 
	 */
	public void setTableStyleName(String value) {

		this.tableStyleName = value;
		computeStyle();

	}

	/**
	 * Gets the value of the tableValidationName property.
	 * 
	 * @return possible object is {@link String }
	 * 
	 */
	public String getTableValidationName() {
		return tableValidationName;
	}

	/**
	 * Sets the value of the tableValidationName property.
	 * 
	 * @param value
	 *            allowed object is {@link String }
	 * 
	 */
	public void setTableValidationName(String value) {
		this.tableValidationName = value;
	}

	/**
	 * Gets the value of the tableFormula property.
	 * 
	 * @return possible object is {@link String }
	 * 
	 */
	public String getTableFormula() {
		return tableFormula;
	}

	/**
	 * Sets the value of the tableFormula property.
	 * 
	 * @param value
	 *            allowed object is {@link String }
	 * 
	 */
	public void setTableFormula(String value) {
		this.tableFormula = value;
	}

	/**
	 * Gets the value of the tableNumberMatrixRowsSpanned property.
	 * 
	 * @return possible object is {@link String }
	 * 
	 */
	public String getTableNumberMatrixRowsSpanned() {
		return tableNumberMatrixRowsSpanned;
	}

	/**
	 * Sets the value of the tableNumberMatrixRowsSpanned property.
	 * 
	 * @param value
	 *            allowed object is {@link String }
	 * 
	 */
	public void setTableNumberMatrixRowsSpanned(String value) {
		this.tableNumberMatrixRowsSpanned = value;
	}

	/**
	 * Gets the value of the tableNumberMatrixColumnsSpanned property.
	 * 
	 * @return possible object is {@link String }
	 * 
	 */
	public String getTableNumberMatrixColumnsSpanned() {
		return tableNumberMatrixColumnsSpanned;
	}

	/**
	 * Sets the value of the tableNumberMatrixColumnsSpanned property.
	 * 
	 * @param value
	 *            allowed object is {@link String }
	 * 
	 */
	public void setTableNumberMatrixColumnsSpanned(String value) {
		this.tableNumberMatrixColumnsSpanned = value;
	}

	/**
	 * Gets the value of the tableValueType property.
	 * 
	 * @return possible object is {@link String }
	 * 
	 */
	public String getTableValueType() {
		if (tableValueType == null) {
			return "string";
		} else {
			return tableValueType;
		}
	}

	/**
	 * Sets the value of the tableValueType property.
	 * 
	 * @param value
	 *            allowed object is {@link String }
	 * 
	 */
	public void setTableValueType(String value) {
		this.tableValueType = value;
	}

	/**
	 * Gets the value of the tableValue property.
	 * 
	 * @return possible object is {@link String }
	 * 
	 */
	public String getTableValue() {
		return tableValue;
	}

	/**
	 * Sets the value of the tableValue property.
	 * 
	 * @param value
	 *            allowed object is {@link String }
	 * 
	 */
	public void setTableValue(String value) {
		this.tableValue = value;
	}

	/**
	 * Gets the value of the tableDateValue property.
	 * 
	 * @return possible object is {@link String }
	 * 
	 */
	public String getTableDateValue() {
		return tableDateValue;
	}

	/**
	 * Sets the value of the tableDateValue property.
	 * 
	 * @param value
	 *            allowed object is {@link String }
	 * 
	 */
	public void setTableDateValue(String value) {
		this.tableDateValue = value;
	}

	/**
	 * Gets the value of the tableTimeValue property.
	 * 
	 * @return possible object is {@link String }
	 * 
	 */
	public String getTableTimeValue() {
		return tableTimeValue;
	}

	/**
	 * Sets the value of the tableTimeValue property.
	 * 
	 * @param value
	 *            allowed object is {@link String }
	 * 
	 */
	public void setTableTimeValue(String value) {
		this.tableTimeValue = value;
	}

	/**
	 * Gets the value of the tableBooleanValue property.
	 * 
	 * @return possible object is {@link String }
	 * 
	 */
	public String getTableBooleanValue() {
		return tableBooleanValue;
	}

	/**
	 * Sets the value of the tableBooleanValue property.
	 * 
	 * @param value
	 *            allowed object is {@link String }
	 * 
	 */
	public void setTableBooleanValue(String value) {
		this.tableBooleanValue = value;
	}

	/**
	 * Gets the value of the tableStringValue property.
	 * 
	 * @return possible object is {@link String }
	 * 
	 */
	public String getTableStringValue() {
		return tableStringValue;
	}

	/**
	 * Sets the value of the tableStringValue property.
	 * 
	 * @param value
	 *            allowed object is {@link String }
	 * 
	 */
	public void setTableStringValue(String value) {
		this.tableStringValue = value;
	}

	/**
	 * Gets the value of the tableCurrency property.
	 * 
	 * @return possible object is {@link String }
	 * 
	 */
	public String getTableCurrency() {
		return tableCurrency;
	}

	/**
	 * Sets the value of the tableCurrency property.
	 * 
	 * @param value
	 *            allowed object is {@link String }
	 * 
	 */
	public void setTableCurrency(String value) {
		this.tableCurrency = value;
	}

	/**
	 * Gets the value of the tableProtected property.
	 * 
	 * @return possible object is {@link String }
	 * 
	 */
	public String getTableProtected() {
		if (tableProtected == null) {
			return "false";
		} else {
			return tableProtected;
		}
	}

	/**
	 * Sets the value of the tableProtected property.
	 * 
	 * @param value
	 *            allowed object is {@link String }
	 * 
	 */
	public void setTableProtected(String value) {
		this.tableProtected = value;
	}

	/**
	 * Gets the value of the tableCellRangeSource property.
	 * 
	 * @return possible object is {@link TableCellRangeSource }
	 * 
	 */
	public TableCellRangeSource getTableCellRangeSource() {
		return tableCellRangeSource;
	}

	/**
	 * Sets the value of the tableCellRangeSource property.
	 * 
	 * @param value
	 *            allowed object is {@link TableCellRangeSource }
	 * 
	 */
	public void setTableCellRangeSource(TableCellRangeSource value) {
		this.tableCellRangeSource = value;
	}

	/**
	 * Gets the value of the officeAnnotation property.
	 * 
	 * @return possible object is {@link OfficeAnnotation }
	 * 
	 */
	public OfficeAnnotation getOfficeAnnotation() {
		return officeAnnotation;
	}

	/**
	 * Sets the value of the officeAnnotation property.
	 * 
	 * @param value
	 *            allowed object is {@link OfficeAnnotation }
	 * 
	 */
	public void setOfficeAnnotation(OfficeAnnotation value) {
		this.officeAnnotation = value;
	}

	/**
	 * Gets the value of the tableDetective property.
	 * 
	 * @return possible object is {@link TableDetective }
	 * 
	 */
	public TableDetective getTableDetective() {
		return tableDetective;
	}

	/**
	 * Sets the value of the tableDetective property.
	 * 
	 * @param value
	 *            allowed object is {@link TableDetective }
	 * 
	 */
	public void setTableDetective(TableDetective value) {
		this.tableDetective = value;
	}

	public void setTextP(TextP p) {
		if (this.textP != null) {
			System.err.println("TableTableCell: Warning: no support for multiple TextP in a Cell");
		} else
			this.textP = p;

	}

	public TextP getTextP() {
		return textP;
	}

	@Override
	public String toString() {
		return "Cell: style:" + this.getStyleName() + " TestP:" + this.getTextP();
	}

	public void setRowAndColumn(TableTableRow r, TableTableColumn c) {
		row = r;
		column = c;
		computeStyle();
	}

	public StyleStyle getStyle() {
		return cellStyle;
	}

	private void computeStyle() {
		if (this.column == null) {
			return;
		}
		String styleName = this.getStyleName();

		if (styleName == null) {
			styleName = this.column.getTableDefaultCellStyleName();
		}
		cellStyle = row.getTable().getCellStyle(styleName);
		if (cellStyle == null /* && styleName != null */) {
			System.err.println(styleName + " not found");
			Thread.dumpStack();
		}

	}

	public void setCovered(boolean b) {
		this.covered = b;

	}

	public boolean isCovered() {
		return this.covered;
	}

	public void addDrawFrame(DrawFrame p) {
		if (drawFrames == null) {
			drawFrames = new Vector<DrawFrame>();
		}
		drawFrames.add(p);
	}

	public List<DrawFrame> getDrawFrames() {
		return drawFrames;
	}

	protected TableTableCell cloneCell() {
		TableTableCell c = new TableTableCell();

		c.tableNumberColumnsRepeated = this.tableNumberColumnsRepeated;
		c.tableNumberRowsSpanned = this.tableNumberRowsSpanned;
		c.tableNumberColumnsSpanned = this.tableNumberColumnsSpanned;
		c.tableStyleName = this.tableStyleName;
		c.tableValidationName = this.tableValidationName;
		c.tableFormula = this.tableFormula;
		c.tableNumberMatrixRowsSpanned = this.tableNumberMatrixRowsSpanned;
		c.tableNumberMatrixColumnsSpanned = this.tableNumberMatrixColumnsSpanned;
		c.tableValueType = this.tableValueType;
		c.tableValue = this.tableValue;
		c.tableDateValue = this.tableDateValue;
		c.tableTimeValue = this.tableTimeValue;
		c.tableBooleanValue = this.tableBooleanValue;
		c.tableStringValue = this.tableStringValue;
		c.tableCurrency = this.tableCurrency;
		c.tableProtected = this.tableProtected;
		c.tableCellRangeSource = this.tableCellRangeSource;
		c.tableDetective = this.tableDetective;
		c.officeAnnotation = this.officeAnnotation;
		c.textP = this.textP;
		c.covered = this.covered;
		c.drawImage = this.drawImage;
		c.drawFrames = this.drawFrames;
		return c;
	}

	public TableTableRow getRow() {
		return row;
	}

}
