/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 2008 jOpenDocument, by ILM Informatique. All rights reserved.
 * 
 * The contents of this file are subject to the terms of the GNU
 * General Public License Version 3 only ("GPL").  
 * You may not use this file except in compliance with the License. 
 * You can obtain a copy of the License at http://www.gnu.org/licenses/gpl-3.0.html
 * See the License for the specific language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each file.
 * 
 */

package org.jopendocument.util;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ValueHelper {

	// 15.2cm
	private static final Pattern lenghPattern = Pattern.compile("(\\d+(\\.\\d+)?)(\\p{Alpha}+)?");
	public static final Color TRANSPARENT = new Color(0, 0, 0, 0);
	// Cache for Color resolution
	private static final Map<String, Color> colors = new HashMap<String, Color>();

	// 0: value, eg 15 ; 1: unit, eg "cm" or null
	private static final String[] parseLength2String(String l) {
		final Matcher m = lenghPattern.matcher(l);
		if (!m.matches())
			throw new IllegalStateException("unable to parse " + l);
		return new String[] { m.group(1), m.group(3) };
	}

	public static final int getLenth(String value) {
		return Math.round(parseLength(value) * 1000);
	}

	public static final float parseLength(final String l) {
		final String[] valAndUnit = parseLength2String(l);
		final String unit = valAndUnit[1];
		final int multiplier;
		if (unit.equals("cm"))
			multiplier = 10;
		else if (unit.equals("mm"))
			multiplier = 1;
		else
			throw new IllegalStateException("unknown unit " + unit);
		return Float.parseFloat(valAndUnit[0]) * multiplier;
	}

	public static final boolean getBoolean(String value) {
		if (value.equals("true")) {
			return (true);
		} else if (value.equals("false")) {
			return (false);
		} else {
			throw new IllegalArgumentException(value + " not a boolean value");
		}
	}

	public final static Color getColor(final String value) {
		if (value == null)
			return null;

		Color c = colors.get(value);
		if (c != null) {
			return c;
		}
		if (value.startsWith("#")) {
			int red = Integer.parseInt(value.substring(1, 3), 16);
			int green = Integer.parseInt(value.substring(3, 5), 16);
			int blue = Integer.parseInt(value.substring(5, 7), 16);

			c = new Color(red, green, blue);
		} else if (value.startsWith("transparent")) {
			c = TRANSPARENT;

		} else {
			System.err.println("unknown color:" + value);
		}
		colors.put(value, c);
		return c;
	}
}
