/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 2008 jOpenDocument, by ILM Informatique. All rights reserved.
 * 
 * The contents of this file are subject to the terms of the GNU
 * General Public License Version 3 only ("GPL").  
 * You may not use this file except in compliance with the License. 
 * You can obtain a copy of the License at http://www.gnu.org/licenses/gpl-3.0.html
 * See the License for the specific language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each file.
 * 
 */

package org.jopendocument.model.office;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

import org.jopendocument.model.number.NumberNumberStyle;
import org.jopendocument.model.style.StylePageLayout;
import org.jopendocument.model.style.StyleStyle;

public class OfficeAutomaticStyles {

	private final List<StyleStyle> styles = new Vector<StyleStyle>();
	private final Map<String, StyleStyle> stylesMap = new HashMap<String, StyleStyle>();

	private final Map<String, StyleStyle> cellStyles = new HashMap<String, StyleStyle>();
	private final Map<String, StyleStyle> tableStyles = new HashMap<String, StyleStyle>();
	private final Map<String, StylePageLayout> pagesLayouts = new HashMap<String, StylePageLayout>();

	private final Map<String, NumberNumberStyle> numberStyles = new HashMap<String, NumberNumberStyle>();

	public List<StyleStyle> getStyles() {
		return styles;
	}

	public void addStyle(StyleStyle style) {
		stylesMap.put(style.getStyleName(), style);
		this.styles.add(style);
	}

	private StyleStyle getStyle(String s, String type) {
		final StyleStyle styleStyle = stylesMap.get(s);
		if (styleStyle == null) {
			Set<String> t = stylesMap.keySet();
			System.err.println(styles);
			for (String string : t) {
				System.err.println("Key:" + string);
			}
			throw new IllegalArgumentException("Unable to find Style name:" + s + " type:" + type);
		}

		return styleStyle;

	}

	public StyleStyle getColumnStyle(String s) {
		return getStyle(s, "table-column");
	}

	public StyleStyle getRowStyle(String s) {
	    if(s==null){
	        throw new IllegalArgumentException("The style name cannot be null");
	    }
		return getStyle(s, "table-row");
	}

	public StyleStyle getCellStyle(String s) {
		StyleStyle result = cellStyles.get(s);
		if (result == null) {
			result = getStyle(s, "table-cell");
			cellStyles.put(s, result);
		}
		return result;
	}

	public StyleStyle getTextStyle(String s) {
		return getStyle(s, "text");
	}

	public StyleStyle getTableStyle(String tableStyleName) {
	    if(tableStyleName==null){
	        throw new IllegalArgumentException("null style name");
	    }
	    
		StyleStyle result = tableStyles.get(tableStyleName);
		if (result == null) {
			result = getStyle(tableStyleName, "table");
			tableStyles.put(tableStyleName, result);
		}
		return result;

	}

	public void addPageLayout(StylePageLayout l) {
		this.pagesLayouts.put(l.getStyleName(), l);
	}

	public StylePageLayout getStylePageLayoutFromStyleName(String pageLayoutStyleName) {
		return this.pagesLayouts.get(pageLayoutStyleName);
	}

	@Override
	public String toString() {
		return "OfficeAutomaticStyles";
	}

}
