//
// $Id: JUploadExceptionUploadFailed.java 441 2008-04-16 07:58:02Z etienne_sf $
// 
// jupload - A file upload applet.
// Copyright 2007 The JUpload Team
// 
// Created: 2006-09-15
// Creator: etienne_sf
// Last modified: $Date: 2008-04-16 09:58:02 +0200 (mer., 16 avr. 2008) $
//
// This program is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free Software
// Foundation; either version 2 of the License, or (at your option) any later
// version. This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
// details. You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software Foundation, Inc.,
// 675 Mass Ave, Cambridge, MA 02139, USA.

package wjhk.jupload2.exception;

/**
 * This exception occurs when an upload failed. It can be generated if the
 * server response to the upload doesn't match the
 * {@link wjhk.jupload2.policies.UploadPolicy#PROP_STRING_UPLOAD_SUCCESS}
 * regular expression.
 * 
 * @author etienne_sf
 * @author $Revision: 441 $
 */
public class JUploadExceptionUploadFailed extends JUploadException {

    /**
     * 
     */
    private static final long serialVersionUID = -9031106357048838553L;

    /**
     * Constructs a new exception with the specified detail message.
     * @param msg The message for this instance.
     */
    public JUploadExceptionUploadFailed(String msg) {
        super(msg);
    }

    /**
     * Constructs a new exception with the specified cause.
     * @param cause The cause for this instance.
     */
    public JUploadExceptionUploadFailed(Throwable cause) {
        super(cause);
    }

    /**
     * Constructs a new exception with the specified detail message and cause.
     * @param msg The message for this instance.
     * @param cause The cause for this instance.
     */
    public JUploadExceptionUploadFailed(String msg, Throwable cause) {
        super(msg, cause);
    }
}
