#!/bin/sh

# let's expose problems:
set -e

ZAP_VER=1.4.10
PRI_VER=1.4.3
AST_VER=1.4.19.1
ADD_VER=1.4.6

# if the need arises: backup the old directory before extracting a
# tarball:
move_dir() {
  olddir="$1"
  if [ ! -d "$olddir" ]; then return; fi

  mkdir -p old
  parent=`mktemp -d "old/$olddir-XXXXXX"` || exit 1
  mv "$olddir" "$parent/"
}

# Save/restore a directory before patching it
backup_dir() {
  dir=$1
  backup=backup_$dir

  if [ ! -d $dir ]; then return; fi # don't add mess

  if [ -d $backup ]; then
    # it was run. Restore before patching $dir:
    rm -rf $dir
    cp -a $backup $dir
  else
    # ./compile.sh was not run before. save:
    cp -a $dir $backup
  fi
}

#wget -c http://updates.xorcom.com/astribank/src/zaptel-${ZAP_VER}.tar.gz
#wget -c http://astimax.de/mirror/zaptel/zaptel-${ZAP_VER}.tar.gz
wget -c http://downloads.digium.com/pub/zaptel/releases/zaptel-${ZAP_VER}.tar.gz
#wget -c http://astimax.de/mirror/libpri/libpri-${PRI_VER}.tar.gz
wget -c http://downloads.digium.com/pub/libpri/releases/libpri-${PRI_VER}.tar.gz
#wget -c http://astimax.de/mirror/asterisk-1.4/asterisk-${AST_VER}.tar.gz
wget -c http://downloads.digium.com/pub/asterisk/releases/asterisk-${AST_VER}.tar.gz
#wget -c http://astimax.de/mirror/asterisk-addons/asterisk-addons-${ADD_VER}.tar.gz
wget -c  http://downloads.digium.com/pub/asterisk/releases/asterisk-addons-${ADD_VER}.tar.gz

move_dir zaptel-${ZAP_VER}
move_dir libpri-${PRI_VER}
move_dir asterisk-${AST_VER}
move_dir asterisk-addons-${ADD_VER}
backup_dir cwain
backup_dir qozap
backup_dir zaphfc
backup_dir ztgsm

tar -xzf zaptel-${ZAP_VER}.tar.gz
tar -xzf libpri-${PRI_VER}.tar.gz
tar -xzf asterisk-${AST_VER}.tar.gz
tar -xzf asterisk-addons-${ADD_VER}.tar.gz

# removing old symlinks, if any:
rm -f zaptel libpri asterisk libgsmat
ln -s zaptel-${ZAP_VER} zaptel
ln -s libpri-${PRI_VER} libpri
ln -s asterisk-${AST_VER} asterisk
ln -s asterisk-addons-${ADD_VER} asterisk-addons
ln -s libgsmat-0.0.3 libgsmat


./apply-patches.sh zaptel patches/zaptel
./apply-patches.sh libpri patches/libpri
./apply-patches.sh asterisk patches/asterisk
./apply-patches.sh cwain patches/cwain
./apply-patches.sh qozap patches/qozap
./apply-patches.sh zaphfc patches/zaphfc
./apply-patches.sh ztgsm patches/ztgsm

# pretend those drivers are in the zaptel directory:
cd zaptel/kernel
ln -sf ../../cwain/cwain.[ch] ../../qozap/qozap.[ch] ../../zaphfc/zaphfc.[ch] ../../ztgsm/ztgsm.[ch] .
cd ..

echo "****************************************************"
echo "         Downloading and patching finished."
echo "****************************************************"
