/*
 * libgsmat: An implementation of GSM 07.07
 *
 * Written by Klaus-Peter Junghanns <support@junghanns.net>
 *
 * Copyright (C) 2005, Junghanns.NET GmbH
 * All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */
 
#ifndef _GSM_INTERNAL_H
#define _GSM_INTERNAL_H

#include <sys/time.h>

typedef enum gsm_state {
	POWER_OFF,
	POWER_ON,
	INIT_0,
	INIT_1,
	INIT_2,
	SIM_PIN_REQ,
	SIM_PUK_REQ,
	SIM_READY,
	READY,
	CALL_PRESENT,
	CALL_ACTIVE,
	RINGING
} gsm_state;

#define GSM_STATE_POWER_OFF	0
#define GSM_STATE_POWER_ON	1
#define GSM_STATE_INIT_0	2
#define GSM_STATE_INIT_1	3
#define GSM_STATE_INIT_2	4
#define GSM_STATE_NET_REQ	5
#define GSM_STATE_SIM_PIN_REQ	6
#define GSM_STATE_SIM_PUK_REQ	7
#define GSM_STATE_SIM_READY	8
#define GSM_STATE_READY		9
#define GSM_STATE_CALL_INIT	10
#define GSM_STATE_CALL_PRESENT	11
#define GSM_STATE_CALL_ACTIVE	12
#define GSM_STATE_RINGING	13

#define GSM_STATE_SM_SEND_REQ	14
#define GSM_STATE_SM_SENDING	15
#define GSM_STATE_SM_RECEIVING	16

#define GSM_STATE_HANGUP_REQ	17
#define GSM_STATE_STATUS_REQ	18
#define GSM_STATE_ERROR		19
#define GSM_STATE_ERROR_HARD	20

#define GSM_DIGITAL_VOLUME	5

struct gsm_sched {
	struct timeval when;
	void (*callback)(void *data);
	void (*callback2)(void *data, int);
	void *data;
	char hasdata2;
	int data2;
};


/* No more than 128 scheduled events */
#define MAX_SCHED 128

struct gsm_modul {
	int fd;				/* File descriptor for D-Channel */
	int span;			/* zaptel span */
	int channel;			/* "d" channel */
	struct gsm_sched gsm_sched[MAX_SCHED];	/* Scheduled events */
	int debug;			/* Debug stuff */
	int debugfd;
	int modemtype;		/* Switch type */
	
 	char dchanup;

	char clip[256];
	char cpn[256];
	int clir;
	int hungup;
	char lastcmd[1024];
	char lasterr[1024];
	char sanbuf[1024];
	char msgbuf[1024];
	int sanidx;
	int echo;
	int lastres;
	/* Used by scheduler */
	struct timeval tv;
	int schedev;
	int state;
	int sim_state;
	int restart_timer;
	gsm_event ev;		/* Static event thingy */
	
};

extern int gsm_schedule_event(struct gsm_modul *gsm, int ms, void (*function)(void *data), void *data);
extern int gsm_schedule_event2(struct gsm_modul *gsm, int ms, void (*function)(void *data, int data2), void *data, int data2);

extern gsm_event *gsm_schedule_run(struct gsm_modul *gsm);

extern void gsm_schedule_del(struct gsm_modul *gsm, int ev);

extern gsm_event *gsm_mkerror(struct gsm_modul *gsm, char *errstr);

extern void gsm_message(struct gsm_modul *gsm, char *fmt, ...);

extern void gsm_error(struct gsm_modul *gsm, char *fmt, ...);

extern int gsm_modem_transmit(struct gsm_modul *gsm, char *data, int len);

extern int gsm_modem_send(struct gsm_modul *gsm, char *data);

extern int gsm_modem_san(struct gsm_modul *gsm, char *in, char *out, int len);

extern void gsm_modem_send_pin(struct gsm_modul *gsm, char *pin);

extern void gsm_modem_error_hard(void *data);

extern void gsm_modem_start(struct gsm_modul *gsm);

extern void gsm_modem_restart(void *data);

extern void gsm_modem_init(struct gsm_modul *gsm);

extern unsigned long gsm_hex2int(char *hex);

extern void gsm_dso2string(char *res, char *dso, int len);

extern void gsm_convertNumber(char *res, char *dso, int len, int toa);

extern void gsm_string2byte(unsigned char res[], char *in, int len);

extern void gsm_to8Bit(unsigned char in[], unsigned char out[], int len);

extern int gsm_pdu2sm_event(struct gsm_modul *gsm, char *pdu);

#endif
