/*
 * realzap.c   
 * Using RTAI to generate zaptel timing!
 *
 * Copyright (C) 2003, 2004, 2005 Junghanns.NET GmbH
 *
 * Klaus-Peter Junghanns <kpj@junghanns.net>
 *
 * This program is free software and may be modified and
 * distributed under the terms of the GNU Public License.
 *
 */

#include <linux/module.h>
#include <asm/io.h>
#include <rtai.h>
#include <rtai_sched.h>
#include <rtai_fifos.h>
#include "..././zaptel-1.0.4/zaptel.h"

#define TICK_PERIOD 1000000
#define TASK_PRIORITY 1
#define STACK_SIZE 10000


typedef struct realzap_zt {
    struct zt_span span;
    struct zt_chan chan;
} realzap_zt;

struct realzap_zt rt_zt;


static RT_TASK rt_task;

static void realzap_loop(int t) {
    for (;;) {
	zt_receive(&(rt_zt.span));
	zt_transmit(&(rt_zt.span));
        rt_task_wait_period();
    }
}

static int realzap_zt_init(void) {
    sprintf(rt_zt.span.name,"REALZAP/1");
    sprintf(rt_zt.span.desc,"%s %d",rt_zt.span.name,1);
    sprintf(rt_zt.chan.name,"REALZAP/%d/%d",1,0);
    rt_zt.chan.chanpos = 1;
    rt_zt.span.chans = &rt_zt.chan;
    rt_zt.span.channels = 0;
    rt_zt.span.deflaw = ZT_LAW_ALAW;
    init_waitqueue_head(&rt_zt.span.maintq);
    rt_zt.span.pvt = &rt_zt;
    rt_zt.chan.pvt = &rt_zt;
    if (zt_register(&rt_zt.span,0)) {
	printk(KERN_CRIT "unable to register zaptel device!\n");
	return -1;
    } else {
	printk(KERN_CRIT "Registered Realtime Zaptel timer\n");
    }
    return 0;
}


int init_module(void) {
    RTIME tick_period;
    realzap_zt_init();
    rt_set_periodic_mode();
    rt_task_init(&rt_task, realzap_loop, 1, STACK_SIZE, TASK_PRIORITY, 0, 0);
    tick_period = start_rt_timer(nano2count(TICK_PERIOD));
    rt_task_make_periodic(&rt_task, rt_get_time() + tick_period, tick_period);
    return 0;
}


void cleanup_module(void) {

    stop_rt_timer();
    rt_task_delete(&rt_task);
    if (zt_unregister(&rt_zt.span)) {
	printk(KERN_CRIT "unable to unregister zaptel device!\n");
    } else {
	printk(KERN_CRIT "Unregistered Realtime Zaptel timer\n");
    }
    return;
}

MODULE_AUTHOR("Klaus-Peter Junghanns <kpj@junghanns.net>");
MODULE_LICENSE("GPL");
