#!/bin/sh

# Let's expose problems:
set -e

BRISTUFF_CONFIRM=${BRISTUFF_CONFIRM:-yes}

BRISTUFF_ZAP_MODS="${BRISTUFF_ZAP_MODS:-cwain qozap zaphfc ztgsm}"

wait_user() {
	if [ "$BRISTUFF_CONFIRM" != 'yes' ]; then return; fi
	echo "****************************************************"
	echo "$*"
	echo "Press <Enter> to continue, or <CTRL> + <C> to abort."
	echo "****************************************************"
	read
}

if [ "$KVERS" != '' ]; then
	BRISTUFF_ZAP_PARAMS="$BRISTUFF_ZAP_PARAMS KVERS=$KVERS"
fi

if [ "$KSRC" != '' ]; then
	BRISTUFF_ZAP_PARAMS="$BRISTUFF_ZAP_PARAMS KSRC=$KSRC"
fi

# The asterisk h323 channel's build breaks the automated build:
# it stops the make in the middle and requires that it is re-run.
# this breaks our ./compile script: running it a second time (in the
# wake of that error) would start with a 'clean'.
#
# If you want h323, get ooh323c from asterisk-addons.
NO_H323=--without-h323

# Allow building/installing as non-root to a destdir.
# for testing.
if [ "$BRISTUFF_DESTDIR" != '' ]; then
	new_usr=$BRISTUFF_DESTDIR/usr
	DEVHACK="DYNFS=yes UDEVRULES="
	DESTDIR_PARAM="DESTDIR=$BRISTUFF_DESTDIR"
	PREFIX_PARAM="INSTALL_PREFIX=$BRISTUFF_DESTDIR"
	CONFIGURE_PARAM="--with-zaptel=$new_usr --with-tonezone=$new_usr --with-pri=$new_usr"
	ADDON_CFG_PARAM="--with-asterisk=$new_usr"
fi

if [ -d zaptel ]; then
	cd zaptel
	./configure
	make MODULES_EXTRA="$BRISTUFF_ZAP_MODS" $BRISTUFF_ZAP_PARAMS clean
	make MODULES_EXTRA="$BRISTUFF_ZAP_MODS" $BRISTUFF_ZAP_PARAMS all
	make MODULES_EXTRA="$BRISTUFF_ZAP_MODS" $BRISTUFF_ZAP_PARAMS install $DESTDIR_PARAM $DEVHACK
	cd ..
	wait_user "ZAPTEL installed"
fi


if [ -d libpri ]; then
	cd libpri
	make clean all
	make install $PREFIX_PARAM
	cd ..
	wait_user "LIBPRI installed."
fi


if [ -d libgsmat ]; then
	cd libgsmat
	make clean all
	make install $PREFIX_PARAM
	cd ..
	wait_user "LIBGSMat installed"
fi

cd asterisk
echo "****************************************************"
echo "If you want to download and compile the iLBC codec ."
echo "please type \"OK\" and press <ENTER> otherwise just "
echo "press <ENTER"
echo "****************************************************"

read ilbc
if [ "$ilbc" == "OK" ] 
then
    ./contrib/scripts/get_ilbc_source.sh
fi


./configure $CONFIGURE_PARAM $NO_H323
make clean 


make all
make install $DESTDIR_PARAM
wait_user "Asterisk installed"

# to install sample asterisk configuration files uncomment the next line
#make samples
cd ..

if [ -d asterisk-addons ]; then
	cd asterisk-addons
	./configure $ADDON_CFG_PARAM
	make clean 
	make all
	make install $DESTDIR_PARAM
	cd ..
fi

echo "****************************************************"
echo " Everything installed."
echo "           BRIstuff Installation finished."
echo "****************************************************"
