require "net/smtp"
require "getoptlong"
require "base64"
require "progressbar"

class ScRubySendMail
	attr_accessor :text
  	attr_accessor :server, :from, :to, :subject

  	def initialize()
    		@boundary = createBoundary()
    		@attachments = []  
		# or Array.new, attachments are stored in an array, each index is an hash (see attach method)
    		@server = "localhost"
    		@subject = "test"
    		@from = @to = @text = ""
  	end

	def createBoundary()
    		return "----=_ScRubySendMail_Part_" + uniqueNumber()
  	end

  	private :createBoundary

  	# create an unique number, length variables

	def uniqueNumber()
    		return sprintf("%02X", rand(99999999 - 10000000) + 10000000) +  # random part
      		sprintf("%02X", Time.new.to_i) +  # machine time
     		sprintf("%02X", $$) +  # process number
      		sprintf("%02X", Time.new.usec())  # micro seconds of machine
  	end

	private :uniqueNumber

  	def attachBinaryFile(phy_filename, real_filename = "")
    		# read file into string and convert it to base64
    		begin
      			f = File.open(phy_filename, "rb");
      			data = f.read()
      			f.close()
    		rescue
      			return false
    		end
    
    		data = [data].pack("m");

    		real_filename = phy_filename if real_filename == ""
    
    		attachment = { "type" => contentType(real_filename), "name" => File.basename(real_filename), "data" => data }
    		@attachments.push(attachment)
  	end

	def contentType(filename)
    		filename = File.basename(filename).downcase
    		if filename =~ /\.jp(e?)g$/ then return "image/jpeg" end
    		if filename =~ /\.gif$/ then return "image/gif" end
    		if filename =~ /\.htm(l?)$/ then return "text/html" end
    		if filename =~ /\.txt$/ then return "text/plain" end
    		if filename =~ /\.zip$/ then return "application/zip" end
    		if filename =~ /\.png$/ then return "image/png" end
    		# more types?!
    		return "application/octet-stream"
  	end

  	private :contentType

	def sendMail()
    		raise "mail server not specified" if @server.length == 0
    		raise "sender address not specified" if @from.length == 0
    		raise "receiver address not specified" if @to.length == 0
    		#raise "nothing to send" if (@text.length == 0) && (@attachments.length == 0)

    		#define progress bar
    		total = 30
    		pbar = ProgressBar.new("[sendmail]", total)

    		smtp = Net::SMTP.new(@server)
    		smtp.start("helo.ba", "username", "password", :login)
		smtp.ready(@from, @to) do |wa|
      		wa.write("Reply-To: #{@from}\r\n")
      		wa.write("To: #{@to}\r\n")
      		wa.write("Subject: #{@subject}\r\n")
      		wa.write("MIME-Version: 1.0\r\n")
      		# add multipart header if we have got attachments
      		if (@attachments.length > 0)
        		wa.write("Content-Type: multipart/mixed; boundary=\"#{@boundary}\"\r\n")
        		wa.write("\r\n")
        		wa.write("This is a multi-part message in MIME format.\r\n")
        		wa.write("\r\n")
      		end
      		sleep(0.1)
      		pbar.inc(10)

      		# add text part if given
      		if (@text.length > 0)
        		# add boundary if we are multiparted, otherwise just add text
        		if (@attachments.length > 0)
          			wa.write("--#{@boundary}\r\n")
          			wa.write("Content-Type: text/plain; charset=\"iso-8859-1\"\r\n")
          			wa.write("Content-Transfer-Encoding: 8bit\r\n")  # we don't take care of very old mail servers with 7 bit only
        		else
          			# if only text and no attachm. we give the encoding
          			wa.write("Content-Type: text/plain; charset=iso-8859-1\r\n")
          			wa.write("Content-Transfer-Encoding: 8bit\r\n")
        		end
        		wa.write("\r\n")
        		wa.write("#{@text}\r\n")
        		wa.write("\r\n")
      		end
      		sleep(0.1)
      		pbar.inc(10)

      		# add attachments if given
      		if (@attachments.length > 0)
        		@attachments.each do |part|
          			wa.write("--#{@boundary}\r\n")
          			wa.write("Content-Type: #{part['type']}; name=\"#{part['name']}\"\r\n")
          			wa.write("Content-Transfer-Encoding: base64\r\n")
          			wa.write("Content-Disposition: attachment; filename=\"#{part['name']}\"\r\n")
          			wa.write("\r\n")
          			wa.write("#{part['data']}")  # no more need for \r\n here!
          			wa.write("\r\n")
        			end
      			end
      			sleep(0.1)
      			pbar.inc(10)

      			# closing boundary if multiparted
      			wa.write("--#{@boundary}--\r\n") if (@attachments.length > 0)
    		end  # smtp.ready(...)
	end  # def sendMail()
end  # class ScRubySendMail


def ScSendMail(m_server, m_from, m_to, m_subject, m_body, m_attach_file)
	#initialize scrubysendmail and define main variables
	mail = ScRubySendMail.new()
	mail.server = m_server
	mail.from = m_from
	mail.to = m_to
	mail.subject = m_subject
	mail.text = m_body
	#attach binary file
	if (!mail.attachBinaryFile(m_attach_file))
		puts "Ne mogu zakaciti fajl " + $m_attach_file + "!"
	end
	begin
		mail.sendMail()
	rescue
    		puts "Greska pri slanju maila: #{$!}"
	end	

end

