/*
 * libgsmat: An implementation of GSM 07.07
 *
 * Written by Klaus-Peter Junghanns <support@junghanns.net>
 *
 * Copyright (C) 2005, Junghanns.NET GmbH
 * All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */
 
#ifndef _GSM_MODEM_H
#define _GSM_MODEM_H

#include <sys/time.h>


extern void gsm_modem_init(struct gsm_modul *gsm);
extern void gsm_modem_send_pin(struct gsm_modul *gsm, char *pin);
extern int gsm_modem_answer(struct gsm_modul *gsm);
extern int gsm_modem_hangup(struct gsm_modul *gsm);
extern gsm_event *gsm_modem_receive(struct gsm_modul *gsm, char *data, int len);
extern int gsm_modem_dial(struct gsm_modul *gsm, int callerpres, char *called);
extern int gsm_modem_sms_send_text(struct gsm_modul *gsm, char *destination, char *msg);
extern int gsm_modem_sms_send_pdu(struct gsm_modul *gsm, char *pdu);
extern int gsm_modem_request_status(struct gsm_modul *gsm);
extern int gsm_modem_poweroff(struct gsm_modul *gsm);



#endif
