/*
 * libgsmat: An implementation of GSM 07.07
 *
 * Written by Klaus-Peter Junghanns <support@junghanns.net>
 *
 * Copyright (C) 2005, Junghanns.NET GmbH
 * All Rights Reserved.
 *
 * Parts taken from libpri-1.0.9
 * Written by Mark Spencer <markster@linux-support.net>
 *
 * Copyright (C) 2001, Linux Support Services, Inc.
 * All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */

#include "libgsmat.h"
#include "gsm_internal.h"
#include <stdio.h>


static int maxsched = 0;

/* Scheduler routines */
int gsm_schedule_event(struct gsm_modul *gsm, int ms, void (*function)(void *data), void *data)
{
	int x;
	struct timeval tv;
	for (x=1;x<MAX_SCHED;x++)
		if ((!gsm->gsm_sched[x].callback2) && (!gsm->gsm_sched[x].callback))
			break;
	if (x == MAX_SCHED) {
		gsm_error(gsm, "No more room in scheduler\n");
		return -1;
	}
	if (x > maxsched)
		maxsched = x;
	gettimeofday(&tv, NULL);
	tv.tv_sec += ms / 1000;
	tv.tv_usec += (ms % 1000) * 1000;
	if (tv.tv_usec > 1000000) {
		tv.tv_usec -= 1000000;
		tv.tv_sec += 1;
	}
	gsm->gsm_sched[x].when = tv;
	gsm->gsm_sched[x].callback = function;
	gsm->gsm_sched[x].callback2 = NULL;
	gsm->gsm_sched[x].data = data;
	gsm->gsm_sched[x].hasdata2 = 0;
	gsm->gsm_sched[x].data2 = 0;
	return x;
}

int gsm_schedule_event2(struct gsm_modul *gsm, int ms, void (*function)(void *data, int data2), void *data, int data2)
{
	int x;
	struct timeval tv;
	for (x=1;x<MAX_SCHED;x++)
		if ((!gsm->gsm_sched[x].callback2) && (!gsm->gsm_sched[x].callback))
			break;
	if (x == MAX_SCHED) {
		gsm_error(gsm, "No more room in scheduler\n");
		return -1;
	}
	if (x > maxsched)
		maxsched = x;
	gettimeofday(&tv, NULL);
	tv.tv_sec += ms / 1000;
	tv.tv_usec += (ms % 1000) * 1000;
	if (tv.tv_usec > 1000000) {
		tv.tv_usec -= 1000000;
		tv.tv_sec += 1;
	}
	gsm->gsm_sched[x].when = tv;
	gsm->gsm_sched[x].callback = NULL;
	gsm->gsm_sched[x].callback2 = function;
	gsm->gsm_sched[x].data = data;
	gsm->gsm_sched[x].hasdata2 = 1;
	gsm->gsm_sched[x].data2 = data2;
	return x;
}

struct timeval *gsm_schedule_next(struct gsm_modul *gsm)
{
	struct timeval *closest = NULL;
	int x;
	for (x=1;x<MAX_SCHED;x++) {
		if ((gsm->gsm_sched[x].callback || gsm->gsm_sched[x].callback2) && 
			(!closest || (closest->tv_sec > gsm->gsm_sched[x].when.tv_sec) ||
				((closest->tv_sec == gsm->gsm_sched[x].when.tv_sec) && 
				 (closest->tv_usec > gsm->gsm_sched[x].when.tv_usec))))
				 	closest = &gsm->gsm_sched[x].when;
	}
	return closest;
}

static gsm_event *__gsm_schedule_run(struct gsm_modul *gsm, struct timeval *tv)
{
 	int x;
 	void (*callback)(void *);
	void (*callback2)(void *, int);
 	void *data;
	int data2;
//	gsm_event *e;

	for (x=1;x<MAX_SCHED;x++) {
		if ((gsm->gsm_sched[x].callback || gsm->gsm_sched[x].callback2) &&
			((gsm->gsm_sched[x].when.tv_sec < tv->tv_sec) ||
			 ((gsm->gsm_sched[x].when.tv_sec == tv->tv_sec) &&
			  (gsm->gsm_sched[x].when.tv_usec <= tv->tv_usec)))) {
			        gsm->schedev = 0;
			  	callback = gsm->gsm_sched[x].callback;
			  	callback2 = gsm->gsm_sched[x].callback2;
				data = gsm->gsm_sched[x].data;
				data2 = gsm->gsm_sched[x].data2;
				gsm->gsm_sched[x].callback = NULL;
				gsm->gsm_sched[x].callback2 = NULL;
				gsm->gsm_sched[x].data = NULL;
				gsm->gsm_sched[x].data2 = 0;
				if (gsm->gsm_sched[x].hasdata2 == 1) {
				    gsm->gsm_sched[x].hasdata2 = 0;
				    callback2(data, data2);
				} else {
				    callback(data);
				}
            if (gsm->schedev)
                  return &gsm->ev;
	    }
	}
	return NULL;
}

gsm_event *gsm_schedule_run(struct gsm_modul *gsm)
{
	struct timeval tv;
	gettimeofday(&tv, NULL);
	return __gsm_schedule_run(gsm, &tv);
}


void gsm_schedule_del(struct gsm_modul *gsm,int id)
{
	if ((id >= MAX_SCHED) || (id < 0)) 
		gsm_error(gsm, "Asked to delete sched id %d???\n", id);
	gsm->gsm_sched[id].callback = NULL;
	gsm->gsm_sched[id].callback2 = NULL;
}
