/*
 * Asterisk -- A telephony toolkit for Linux.
 *
 * XAGI sample script
 *
 * Copyright (C) 2005 Junghanns.NET GmbH
 * Klaus-Peter Junghanns <kpj@junghanns.net>
 *
 * based on eagi-test.c
 *
 * This program is free software, distributed under the terms of
 * the GNU General Public License
 */

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>
#include <sys/select.h>
#ifdef SOLARIS
#include <solaris-compat/compat.h>
#endif

#define AUDIO_FILENO_IN (STDERR_FILENO + 1)
#define AUDIO_FILENO_OUT (STDERR_FILENO + 2)

static int read_environment(void)
{
	char buf[256];
	char *val;
	/* Read environment */
	for(;;) {
		fgets(buf, sizeof(buf), stdin);
		if (feof(stdin))
			return -1;
		buf[strlen(buf) - 1] = '\0';
		/* Check for end of environment */
		if (!strlen(buf))
			return 0;
		val = strchr(buf, ':');
		if (!val) {
			fprintf(stderr, "Invalid environment: '%s'\n", buf);
			return -1;
		}
		*val = '\0';
		val++;
		val++;
		/* Skip space */
	//	fprintf(stderr, "Environment: '%s' is '%s'\n", buf, val);

		/* Load into normal environment */
		setenv(buf, val, 1);

	}
	/* Never reached */
	return 0;
}

static void app_echo(void)
{
	fd_set fds;
	int res;
	int bytes = 0;
	static char astresp[256];
	char audiobuf[16000]; /* 1 second of audio */
	for (;;) {
		FD_ZERO(&fds);
		FD_SET(STDIN_FILENO, &fds);
		FD_SET(AUDIO_FILENO_IN, &fds);
		/* Wait for *some* sort of I/O */
		res = select(AUDIO_FILENO_IN + 1, &fds, NULL, NULL, NULL);
		if (res < 0) {
			fprintf(stderr, "Error in select: %s\n", strerror(errno));
			return;
		}
		if (FD_ISSET(STDIN_FILENO, &fds)) {
			fgets(astresp, sizeof(astresp), stdin);
			if (feof(stdin)) {
				return;
			}
			astresp[strlen(astresp) - 1] = '\0';
			fprintf(stderr, "Ooh, got a response from Asterisk: '%s'\n", astresp);
			return;
		}
		if (FD_ISSET(AUDIO_FILENO_IN, &fds)) {
			/* what goes in.... */
			res = read(AUDIO_FILENO_IN, audiobuf, sizeof(audiobuf));
			if (res > 0) {
			    bytes = res;
			    /* must come out */
			    write(AUDIO_FILENO_OUT, audiobuf, bytes);
			}
		}
	}
}

static char *wait_result(void)
{
	fd_set fds;
	int res;
	static char astresp[256];
	char audiobuf[4096];
	for (;;) {
		FD_ZERO(&fds);
		FD_SET(STDIN_FILENO, &fds);
		FD_SET(AUDIO_FILENO_IN, &fds);
		/* Wait for *some* sort of I/O */
		res = select(AUDIO_FILENO_IN + 1, &fds, NULL, NULL, NULL);
		if (res < 0) {
			fprintf(stderr, "Error in select: %s\n", strerror(errno));
			return NULL;
		}
		if (FD_ISSET(STDIN_FILENO, &fds)) {
			fgets(astresp, sizeof(astresp), stdin);
			if (feof(stdin)) {
				fprintf(stderr, "Got hungup on apparently\n");
				return NULL;
			}
			astresp[strlen(astresp) - 1] = '\0';
			fprintf(stderr, "Ooh, got a response from Asterisk: '%s'\n", astresp);
			return astresp;
		}
		if (FD_ISSET(AUDIO_FILENO_IN, &fds)) {
			res = read(AUDIO_FILENO_IN, audiobuf, sizeof(audiobuf));
			/* drop it, like it's hot */
		}
	}

}

static char *run_command(char *command)
{
	fprintf(stdout, "%s\n", command);
	return wait_result();
}


static int run_script(void)
{
	char *res;
		res = run_command("STREAM FILE demo-echotest \"\"");
	if (!res) {
		fprintf(stderr, "Failed to execute command\n");
		return -1;
	}
	app_echo();
	return 0;
}

int main(int argc, char *argv[])
{
	char *tmp;
	int ver = 0;
	int subver = 0;
	/* Setup stdin/stdout for line buffering */
	setlinebuf(stdin);
	setlinebuf(stdout);
	if (read_environment()) {
		fprintf(stderr, "Failed to read environment: %s\n", strerror(errno));
		exit(1);
	}
	tmp = getenv("agi_enhanced");
	if (tmp) {
		if (sscanf(tmp, "%d.%d", &ver, &subver) != 2)
			ver = 0;
	}
	if (ver < 2) {
		fprintf(stderr, "No XAGI services available.  Use XAGI, not AGI or EAGI\n");
		exit(1);
	}
	if (run_script())
		return -1;
	exit(0);
}
