#include "hbgtinfo.ch"
#include "inkey.ch"
#include "box.ch"



FUNCTION Main()

my_qt_window()

#define POL_MAZ   " "
#define POL_ISO   "ʣӦ󶼿"
#define POL_852   "䢘"
#define POL_WIN   "ʣӌ󜟿"

REQUEST HB_CODEPAGE_PLMAZ
REQUEST HB_CODEPAGE_PLISO
REQUEST HB_CODEPAGE_PL852
REQUEST HB_CODEPAGE_PLWIN

cOk := "Y                             "

cTermCP:=""
cHostCP:=""
lBoxChar:=.t.

if empty( cTermCP )
    cTermCP := "PLWIN"
else
    cTermCP := upper( cTermCP )
endif

if empty( cHostCP )
    cHostCP := "PLWIN"
else
    cHostCP := upper( cHostCP )
endif
lBoxChar := !empty( lBoxChar )


HB_SETTERMCP( cTermCP, cHostCP, lBoxChar )

? OS(), VERSION(), DATE(), TIME()
? HB_GTVERSION(), HB_GTVERSION(1)
? "Host codpage: " + cHostCP + ", terminal codepage: " + cTermCP

inkey(0)

@ 0,10 SAY "Hello world" GET cOk
read
RETURN NIL

PROCEDURE HB_GTSYS()
   REQUEST HB_GT_QTC_DEFAULT
   RETURN


PROCEDURE MyErrorSys( oError )

   ? oError:Description
   ? oError:args
   ? oError:genCode
   ? oError:operation

   ? procname(1), procline(1)
   ? procname(2), procline(2)
   ? procname(3), procline(3)

   do while inkey() <> 27
   enddo

RETURN



#define QT_PTROF( oObj )  ( oObj:pPtr )

#define QT_EVE_TRIGGERED   "triggered(bool)"
#define QT_EVE_TRIGGERED_B "triggered(bool)"
#define QT_EVE_HOVERED     "hovered()"
#define QT_EVE_CLICKED     "clicked()"



function my_qt_window()

oWnd := QMainWindow():new()

oWnd:setWindowTitle( "Testing - QMainWindow, QMenu, QMenuBar and QAction " )
oWnd:resize( 640, 200 )

Build_MenuBar( oWnd )

oWnd:show()

return



STATIC FUNCTION Build_MenuBar( oWnd )
   LOCAL oMenuBar, oMenu

   oMenuBar := QMenuBar():new( QT_PTROF( oWnd ) )
  //oMenuBar:resize( oWnd:width(), 25 )

    oMenu := QMenu():new( QT_PTROF( oMenuBar ) )
   oMenu:setTitle( "&File" )

    Qt_Connect_Signal( oMenu:addAction( "&Colors"    ), QT_EVE_TRIGGERED_B, {|w,l| Dialogs( "Colors"   , w, l ) } )

    oMenu:addSeparator()


//   Qt_Connect_Signal( oMenu:addAction_1( "new.png" , "&New"  ), QT_EVE_TRIGGERED_B, {|w,l| FileDialog( "New" , w, l ) } )
//   Qt_Connect_Signal( oMenu:addAction_1( "open.png", "&Open" ), QT_EVE_TRIGGERED_B, {|w,l| FileDialog( "Open", w, l ) } )
//   oMenu:addSeparator()
//   Qt_Connect_Signal( oMenu:addAction_1( "save.png", "&Save" ), QT_EVE_TRIGGERED_B, {|w,l| FileDialog( "Save", w, l ) } )
//   oMenu:addSeparator()
//   Qt_Connect_Signal( oMenu:addAction( "E&xit" ), QT_EVE_TRIGGERED_B, {|w,l| MsgInfo( "Exit ?" ) } )
//   oMenuBar:addMenu( QT_PTROF( oMenu ) )

/*
   oMenu := QMenu():new( QT_PTROF( oMenuBar ) )
   oMenu:setTitle( "&Dialogs" )
   Qt_Connect_Signal( oMenu:addAction( "&Colors"    ), QT_EVE_TRIGGERED_B, {|w,l| Dialogs( "Colors"   , w, l ) } )
   Qt_Connect_Signal( oMenu:addAction( "&Fonts"     ), QT_EVE_TRIGGERED_B, {|w,l| Dialogs( "Fonts"    , w, l ) } )
   oMenu:addSeparator()
   Qt_Connect_Signal( oMenu:addAction( "&PageSetup" ), QT_EVE_TRIGGERED_B, {|w,l| Dialogs( "PageSetup", w, l ) } )
   Qt_Connect_Signal( oMenu:addAction( "P&review"   ), QT_EVE_TRIGGERED_B, {|w,l| Dialogs( "Preview"  , w, l ) } )
   oMenu:addSeparator()
   Qt_Connect_Signal( oMenu:addAction( "&Wizard"    ), QT_EVE_TRIGGERED_B, {|w,l| Dialogs( "Wizard"   , w, l ) } )
   Qt_Connect_Signal( oMenu:addAction( "W&ebPage"   ), QT_EVE_TRIGGERED_B, {|w,l| Dialogs( "WebPage"  , w, l ) } )
   oMenuBar:addMenu( QT_PTROF( oMenu ) )
*/

   oWnd:setMenuBar( QT_PTROF( oMenuBar ) )

RETURN nil



STATIC FUNCTION Dialogs( cType, w, l )
   LOCAL oDlg, oUrl

   DO CASE
   CASE cType == "Colors"
      oDlg := QColorDialog():new()
      oDlg:setWindowTitle( "Harbour-QT Color Selection Dialog" )
      oDlg:show()
   CASE cType == "WebPage"
      oDlg := QWebView():new()
      oUrl := QUrl():new()
      oUrl:setUrl( "http://www.harbour.vouch.info" )
      QT_QWebView_SetUrl( QT_PTROF( oDlg ), QT_PTROF( oUrl ) )
      oDlg:setWindowTitle( "Harbour-QT Web Page Navigator" )
      oDlg:show()
   CASE cType == "Fonts"
      oDlg := QFontDialog():new()
      oDlg:setWindowTitle( "Harbour-QT Font Selector" )
      oDlg:show()
   ENDCASE

RETURN nil
