/****************************************************************************
**
** Copyright (C) 2008 Nokia Corporation and/or its subsidiary(-ies).
** Contact: Qt Software Information (qt-info@nokia.com)
**
** This file is part of the documentation of Qt. It was originally
** published as part of Qt Quarterly.
**
** Commercial Usage
** Licensees holding valid Qt Commercial licenses may use this file in
** accordance with the Qt Commercial License Agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and Nokia.
**
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License versions 2.0 or 3.0 as published by the Free
** Software Foundation and appearing in the file LICENSE.GPL included in
** the packaging of this file.  Please review the following information
** to ensure GNU General Public Licensing requirements will be met:
** http://www.fsf.org/licensing/licenses/info/GPLv2.html and
** http://www.gnu.org/copyleft/gpl.html.  In addition, as a special
** exception, Nokia gives you certain additional rights. These rights
** are described in the Nokia Qt GPL Exception version 1.3, included in
** the file GPL_EXCEPTION.txt in this package.
**
** Qt for Windows(R) Licensees
** As a special exception, Nokia, as the sole copyright holder for Qt
** Designer, grants users of the Qt/Eclipse Integration plug-in the
** right for the Qt/Eclipse Integration to link to functionality
** provided by Qt Designer and its related libraries.
**
** If you are unsure which license is appropriate for your use, please
** contact the sales department at qt-sales@nokia.com.
**
****************************************************************************/

#include "phonebillwriter.h"

PhoneBillWriter::PhoneBillWriter(const QString &clientName)
    : m_document(new QTextDocument()),
    m_cursor(m_document)
{
    m_cursor.insertText(QString("Phone bill for %1\n").arg(clientName));

    QTextTableFormat tableFormat;
    tableFormat.setCellPadding(5);
    tableFormat.setHeaderRowCount(1);
    tableFormat.setBorderStyle(QTextFrameFormat::BorderStyle_Solid);
    tableFormat.setWidth(QTextLength(QTextLength::PercentageLength, 100));
    m_cursor.insertTable(1, 3, tableFormat);
    m_cursor.insertText("Date");
    m_cursor.movePosition(QTextCursor::NextCell);
    m_cursor.insertText("Duration (sec)");
    m_cursor.movePosition(QTextCursor::NextCell);
    m_cursor.insertText("Cost");
}

PhoneBillWriter::~PhoneBillWriter()
{
    delete m_document;
}

void PhoneBillWriter::addPhoneCall(const PhoneBillWriter::PhoneCall &call)
{
    QTextTable *table = m_cursor.currentTable();
    if (! table)
        return;

    table->appendRows(1); // moves our cursor to the end of the doc...
    m_cursor.movePosition(QTextCursor::PreviousRow);
    m_cursor.movePosition(QTextCursor::NextCell);
    m_cursor.insertText(call.date.toString());
    m_cursor.movePosition(QTextCursor::NextCell);
    m_cursor.insertText(QString::number(call.duration));
    m_cursor.movePosition(QTextCursor::NextCell);

    QChar euro(0x20ac);
    m_cursor.insertText(QString("%1 %2").arg(euro).arg(call.cost / (double) 100, 0, 'f', 2));
}

void PhoneBillWriter::addPastUsageGraph(QList<int> values, const QString &subtext)
{
    const int columnSize = 10;
    int width = values.count() * columnSize;
    int max = 0;
    foreach (int x, values)
        max = qMax(max, x);
    QImage image(width, 100, QImage::Format_Mono);
    QPainter painter(&image);
    painter.fillRect(0, 0, image.width(), image.height(), Qt::white); // background
    for (int index = 0; index < values.count(); ++index) {
        int height = values[index] * 100 / max; // adjust scale to our 100 pixel tall image
        painter.fillRect(index * columnSize, image.height() - height, columnSize, height, Qt::black);
    }
    painter.end();

    QTextCursor cursor(m_document);
    cursor.movePosition(QTextCursor::End);
    cursor.insertText(subtext);
    cursor.insertBlock();
    cursor.insertImage(image);
}

void PhoneBillWriter::write(const QString &fileName)
{
    QTextDocumentWriter writer(fileName);
    writer.write(m_document);
}
