/****************************************************************************
**
** Copyright (C) 2008 Nokia Corporation and/or its subsidiary(-ies).
** Contact: Qt Software Information (qt-info@nokia.com)
**
** This file is part of the documentation of Qt. It was originally
** published as part of Qt Quarterly.
**
** Commercial Usage
** Licensees holding valid Qt Commercial licenses may use this file in
** accordance with the Qt Commercial License Agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and Nokia.
**
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License versions 2.0 or 3.0 as published by the Free
** Software Foundation and appearing in the file LICENSE.GPL included in
** the packaging of this file.  Please review the following information
** to ensure GNU General Public Licensing requirements will be met:
** http://www.fsf.org/licensing/licenses/info/GPLv2.html and
** http://www.gnu.org/copyleft/gpl.html.  In addition, as a special
** exception, Nokia gives you certain additional rights. These rights
** are described in the Nokia Qt GPL Exception version 1.3, included in
** the file GPL_EXCEPTION.txt in this package.
**
** Qt for Windows(R) Licensees
** As a special exception, Nokia, as the sole copyright holder for Qt
** Designer, grants users of the Qt/Eclipse Integration plug-in the
** right for the Qt/Eclipse Integration to link to functionality
** provided by Qt Designer and its related libraries.
**
** If you are unsure which license is appropriate for your use, please
** contact the sales department at qt-sales@nokia.com.
**
****************************************************************************/

#include <QtGui>

#include "phonebillwriter.h"

int main(int c, char **v) {
    QApplication app(c,v);


    PhoneBillWriter phoneBill("Thomas Zander");

    QDateTime dt(QDate(2008, 04, 01), QTime(9, 4, 31));
    qsrand(QDateTime().secsTo(QDateTime::currentDateTime()));

    for (int i=0; i < 10; ++i) {
        PhoneBillWriter::PhoneCall call;
        dt = dt.addSecs(qrand() >> 13);
        call.date = dt;
        call.duration = qrand() >> 20;
        call.cost = call.duration / 4;
        phoneBill.addPhoneCall(call);

        dt = dt.addSecs(call.duration);
    }

    QStringList months;
    months << "April" << "May" << "June" << "July" << "August" << "September"
           << "October" << "November" << "December" << "January" << "February"
           << "March";
    QList<int> callsPerMonth;
    callsPerMonth << 6 << 84 << 76 << 0 << 93 << 128 << 76 << 31 << 19 << 4 << 12 << 78;
    phoneBill.addPastUsageGraph(months, callsPerMonth, "Your past usage:");

    phoneBill.write("phonebill.odt");
}

/*
    add
    QIcon::QIcon(const QByteArray &bytes, const QString &filetype) constructor ??
        // filetype has to be one of QIconEnginePluginV2 keys

    // to render an svg see;
    // see qabstracttextdocumentlayout.cpp api docs (line 47 of the src/gui/text/qabstracttextdocumentlayout.cpp)
*/
