#!/bin/sh

IP_WAN=`ifconfig ppp0 | grep -o  "inet addr:\(.*\) P-t-P" | sed -e "s/inet addr://" | sed -e "s/ P-t-P//" | sed -e "s/ //g"`
echo ipwan=$IP_WAN

add_route() {

local net=$1
local via=$2
local dev=$3

echo $net, $dev

# if you say:
# ip route add 195.222.33.151 dev ppp0
# then ip route show  =>
#                          195.222.33.151 dev ppp0  scope link


if [ "$via" == "link" ]
then 
  ROUTE_EXISTS=`ip route show  | grep -c "$net dev $dev.*link"`
else
 ROUTE_EXISTS=`ip route show  | grep -c "$net via $via dev $dev"`
fi

#echo net=$net, via=$via, dev=$dev,  exists=$ROUTE_EXISTS

if [ "$ROUTE_EXISTS" == "0" ] 
then
  if [ "$via" == "link" ]
  then
     echo ip route add $net dev $dev
     ip route add $net dev $dev
  else
     echo ip route add $net via $via dev $dev
     ip route add $net via $via dev $dev
  fi
fi

}

VPN_ROUTER="192.168.45.5"

#freezone

add_route "10.100.37.51"   "10.0.0.1" "ppp1"
add_route "10.100.37.50"   "10.0.0.1" "ppp1"

add_route "195.222.32.8"  "10.0.0.1" "ppp1"
add_route "195.222.32.10"  "10.0.0.1" "ppp1"
add_route "195.222.32.20"  "10.0.0.1" "ppp1" 
add_route "195.222.32.15"  "10.0.0.1" "ppp1"
add_route "195.222.32.16"  "10.0.0.1" "ppp1"
add_route "195.222.32.34"  "10.0.0.1" "ppp1"
add_route "195.222.32.45"  "10.0.0.1" "ppp1"
add_route "195.222.32.46"  "10.0.0.1" "ppp1"
add_route "195.222.32.48"  "10.0.0.1" "ppp1"
add_route "195.222.32.54"  "10.0.0.1" "ppp1"
add_route "195.222.32.56"  "10.0.0.1" "ppp1"  
add_route "195.222.32.60"  "10.0.0.1" "ppp1"
add_route "195.222.32.61"  "10.0.0.1" "ppp1"
add_route "195.222.32.130" "10.0.0.1" "ppp1"
add_route "195.222.32.131" "10.0.0.1" "ppp1"
add_route "195.222.32.132" "10.0.0.1" "ppp1"   
add_route "195.222.32.161" "10.0.0.1" "ppp1"

add_route "195.222.33.148"  "10.0.0.1" "ppp1"
add_route "195.222.33.149"  "10.0.0.1" "ppp1"
add_route "195.222.33.157"  "10.0.0.1" "ppp1"
add_route "195.222.33.163"  "10.0.0.1" "ppp1"
add_route "195.222.33.229"  "10.0.0.1" "ppp1"
add_route "195.222.33.239"  "10.0.0.1" "ppp1"
add_route "195.222.33.204"  "10.0.0.1" "ppp1"

add_route "207.38.11.34"  "10.0.0.1" "ppp1" 
add_route "207.38.10.110" "10.0.0.1" "ppp1" 
add_route "207.135.145.7" "10.0.0.1" "ppp1"

add_route "208.167.225.2" "10.0.0.1" "ppp1" 

add_route "63.146.124.14" "10.0.0.1" "ppp1"
add_route "63.146.124.40" "10.0.0.1" "ppp1" 
add_route "63.146.124.56" "10.0.0.1" "ppp1"

add_route "192.246.40.62" "10.0.0.1" "ppp1" 

add_route "80.65.85.132"  "10.0.0.1" "ppp1"
add_route "80.65.85.137"  "10.0.0.1" "ppp1"

#endof freezone

add_route "192.168.11.0/24" $VPN_ROUTER "br-lan"
add_route "192.168.65.0/24" $VPN_ROUTER "br-lan"
add_route "192.168.66.0/24" $VPN_ROUTER "br-lan"
add_route "192.168.42.0/24" $VPN_ROUTER "br-lan"
add_route "192.168.43.0/24" $VPN_ROUTER "br-lan"
add_route "192.168.44.0/24" $VPN_ROUTER "br-lan"
add_route "192.168.55.0/24" $VPN_ROUTER "br-lan"
add_route "192.168.4.0/24" $VPN_ROUTER "br-lan"

add_route "10.100.39.0/27" $VPN_ROUTER "br-lan"

#nema vise 169-ice
#add_route "192.169.45.0/24" "192.168.45.4" "br-lan"

