#! /bin/sh

# install_prereq: a script to install distribution-specific
# prerequirements

set -e

usage() {
  echo "$0: a script to install distribution-specific prerequirement"
  echo 'Revision: $Id: prereq.sh 4905 2007-10-21 15:45:17Z tzafrir $'
  echo ""
  echo "Usage: $0:         Shows this message."
  echo "Usage: $0 test     Prints commands it is about to run."
  echo "Usage: $0 install  Really install."
}

# for zaptel:
PACKAGES_DEBIAN="build-essential"
# zaptel:
PACKAGES_DEBIAN="$PACKAGES_DEBIAN libnewt-dev libusb-dev fxload"
# Asterisk: basic requirements:
PACKAGES_DEBIAN="$PACKAGES_DEBIAN bison libncurses-dev libz-dev libssl-dev"
# Asterisk: very useful addons:
PACKAGES_DEBIAN="$PACKAGES_DEBIAN libcurl-dev libspeex-dev libogg-dev libvorbis-dev libasound2-dev"
# Asterisk: nice-to-have addons:
PACKAGES_DEBIAN="$PACKAGES_DEBIAN libpq-dev unixodbc-dev libsqlite-dev"
# Not so nice addon:
#PACKAGES_DEBIAN="$PACKAGES_DEBIAN libopenh323-dev"
# Extras for 1.4:
PACKAGES_DEBIAN="$PACKAGES_DEBIAN libsnmp-dev libiksemel-dev "

PACKAGES_RH="gcc gcc-c++ bison ncurses-devel newt-devel openssl-devel usbutils libusb-devel"

XORCOM_REPO="http://updates.xorcom.com/astribank/trixbox/repo"

KVERS=`uname -r`

case "$1" in
test)    testcmd=echo ;;
install) testcmd='' ;;
'') usage; exit 0 ;;
*) usage; exit 1 ;;
esac



has_kernel_source() {
	test -r /lib/modules/$KVERS/build/.config
}

in_test_mode() {
  test "$testcmd" != ''
}

# Fixme: should be done by apt and not by dpkg?
check_installed_debs() {
	 dpkg-query -W --showformat '${Status} ${Package}\n' "$@" 2>/dev/null \
	 | awk '/ not-installed/{print $4}'
}

# parsing the output of yum is close to impossible.
# We'll use rpm and hope for the best:
check_installed_rpms() {
	for pack in "$@"
	do
		if ! rpm -q $pack >/dev/null 2>/dev/null
		then echo $pack
		fi
	done
}

handle_debian() {
	# echo "# Distribution is Debian or compatible"
	kernel_package=''
	extra_packs=`check_installed_debs $PACKAGES_DEBIAN`
	if ! has_kernel_source; then
		kernel_package="linux-headers-$KVERS"
		debian_release=`cat /etc/debian_version`
		case "$debian_release" in
		3.1) kernel_package="kernel-headers-$KVERS";;
		esac
		echo "# Kernel source not found. Installing $kernel_package"
	fi
	if [ "$extra_packs$kernel_package" = '' ]; then
		return
	fi
	$testcmd apt-get install -y $extra_packs $kernel_package
}

handle_rh() {
	# echo "# Distribution is RedHat or similar."
	kernel_package=''
	extra_packs=`check_installed_rpms $PACKAGES_RH`
	if ! has_kernel_source; then
		kern_str='' # extra "kernel version"
		case "$KVERS" in
		*smp*) kern_str='-smp';;
		*PAE*) kern_str='-PAE';;
		*xen*) kern_str='-xen';;
		esac
		kernel_package="kernel$kern_str-devel-$KVERS"
		echo "# Kernel source not found. Installing $kernel_package"

		echo "# if you get an error for the following command, consider"
		echo "#"
		echo "#yum install -y kernel$kern_str kernel$kern_str-devel"
		echo "#"
		echo "# and then reboot to upgrade to the newly installed kernel."
	fi
	if [ "$extra_packs$kernel_package" = '' ]; then
		return
	fi
	$testcmd yum install -y $extra_packs $kernel_package

	if [ ! -x /usr/sbin/fxload ] && [ ! -x /sbin/fxload ]; then
		# This is probably a centos 5, and it needs fxload 
		# (firmware loader for e.g. the Xorcom Astribank)
		$testcmd rpm -Uvh http://updates.xorcom.com/astribank/fxload/fxload-2002_04_11-5xr.i386.rpm
	fi

	# yum may actually silently ignore certain packages:
	if ! has_kernel_source; then
		echo "# yum failed to installed $kernel_package ."
		echo "# You must install it to build Zaptel. Aborting."
		exit 1
	fi
}

if in_test_mode; then
	echo "#############################################"
	echo "## $1: test mode."
	echo "## Use the commands here to install your system."
	echo "#############################################"
fi

# handle the easy case of Debians first
if [ -r /etc/debian_version ]; then
  handle_debian
elif [ -r /etc/redhat-release ]; then
  handle_rh
fi

echo "#############################################"
echo "## $1 completed successfully"
if in_test_mode; then
	echo "## (in test mode)"
fi
echo "#############################################"
