#!/bin/bash

BRISTUFF_ZAP_MODS="${BRISTUFF_ZAP_MODS:-cwain qozap zaphfc ztgsm}"
if [ "$KVERS" != '' ]; then
	BRISTUFF_ZAP_PARAMS="$BRISTUFF_ZAP_PARAMS KVERS=$KVERS"
fi

if [ "$KSRC" != '' ]; then
	BRISTUFF_ZAP_PARAMS="$BRISTUFF_ZAP_PARAMS KSRC=$KSRC"
fi


cd zaptel
make MODULES_EXTRA="$BRISTUFF_ZAP_MODS" $BRISTUFF_ZAP_PARAMS clean
make MODULES_EXTRA="$BRISTUFF_ZAP_MODS" $BRISTUFF_ZAP_PARAMS all
make MODULES_EXTRA="$BRISTUFF_ZAP_MODS" $BRISTUFF_ZAP_PARAMS install
cd ..

echo "****************************************************"
echo "Press <Enter> to continue, or <CTRL> + <C> to abort."
echo "****************************************************"
read

cd libpri
make clean all
make install
cd ..

echo "****************************************************"
echo "LIBPRI installed."
echo "Press <Enter> to continue, or <CTRL> + <C> to abort."
echo "****************************************************"
read

cd libgsmat
make clean all
make install
cd ..

echo "****************************************************"
echo "LIBGSM installed."
echo "Press <Enter> to continue, or <CTRL> + <C> to abort."
echo "****************************************************"
read

cd asterisk
make clean 

echo "****************************************************"
echo "If you want to download and compile the iLBC codec ."
echo "please type \"OK\" and press <ENTER> otherwise just "
echo "press <ENTER"
echo "****************************************************"

read ilbc
if [ "$ilbc" == "OK" ] 
then
    ./contrib/scripts/get_ilbc_source.sh
fi

make all
make install

# to install sample asterisk configuration files uncomment the next line
#make samples
cd ..

#uncomment to build cdr_mysql
#cd addons
#cd asterisk-addons-1.2.8
#make cdr_addon_mysql.so
#cp cdr_addon_mysql.so $INSTALL_PREFIX/usr/lib/asterisk/modules/

echo "****************************************************"
echo " ASTERISK installed."
echo "           BRIstuff Installation finished."
echo "****************************************************"
