#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>
#include <math.h>
#include "libgsmat.h"
#include "gsm_internal.h"

unsigned long gsm_hex2int(char *hex) {
    int len,i,j;
    unsigned long res = 0;
    len = strlen(hex);
    for (i=0; i<len; i++) {
	j = 0;
	if ((hex[i] >= 48) && (hex[i] <=57)) {
	    j = hex[i] - 48;
	} else if ((hex[i] >= 65) && (hex[i] <=70)) {
	    j = hex[i] - 55;
	} else if ((hex[i] >= 97) && (hex[i] <=102)) {
	    j = hex[i] - 87;
	}
	res += j * (unsigned long)pow(16, len - i - 1);
    }
    return res;
}

void gsm_dso2string(char *res, char *dso, int len) {
    int i;
    for (i=0; i < len; i++) {
	res[i*2] = dso[(i*2)+1];
	if ((i != len -1) && (dso[i*2] != 'F') && (dso[i*2] != 'f')) {
	    res[(i*2)+1] = dso[i*2];
	}
    }
    res[len*2] = '\0';
}

void gsm_convertNumber(char *res, char *dso, int len, int toa) {
    if (toa == 0x91) {
	res[0] = '+';
	gsm_dso2string(res+1, dso, len);
    } else {
	gsm_dso2string(res, dso, len);
    }
}

void gsm_string2byte(unsigned char res[], char *in, int len) {
    int i = 0;
    char buf[3];
    for (i=0; i < len ; i++) {
	strncpy(buf, &in[i*2], 2);
	buf[2] = '\0';
	res[i] = gsm_hex2int(buf);
    }
}

void gsm_to8Bit(unsigned char in[], unsigned char out[], int len) {
    int i = 0;
    int inputOffset = 0;
    int outputOffset = 0;

    while (inputOffset < len ) {
	out[outputOffset] = (in[inputOffset] & (unsigned char)(pow(2, 7-i)-1));
	if (i == 8) {
	    out[outputOffset] = in[inputOffset-1] & 127;
	    i = 1;
	} else {
	    out[outputOffset] = out[outputOffset] << i;
	    out[outputOffset] |= in[inputOffset-1] >> (8-i);
	    inputOffset++;
	    i++;
	}
	outputOffset++;
    }    
}

int gsm_pdu2sm_event(struct gsm_modul *gsm, char *pdu) {
    int len;
    int smsc_len = 0;
    unsigned char smsc_toa;
    char smsc_number[256];
    char smsc_number_dso[256];
    int sender_len = 0;
    unsigned char sender_toa;
    char sender_number[256];
    char sender_number_dso[256];
    char buf[256];
    unsigned int dcs, pid;
    char timestamp[256];
    char timestamp_dso[256];
    int udl=0;
    char user_data[256];
    unsigned char user_data_7bit[256];
    unsigned char user_data_8bit[256];
    
    len = strlen(pdu);
    if (len < 14) {
	gsm_error(gsm, "PDU too short\n");
	return -1;
    }

    strncpy(gsm->ev.sm_received.pdu, pdu, sizeof(gsm->ev.sm_received.pdu) - 1);

    /* SMSC information length */
    strncpy(buf, pdu, sizeof(buf) - 1);
    buf[2] = '\0';
    smsc_len = gsm_hex2int(buf);
    if (gsm->debug)
	gsm_message(gsm, "smsc_len = %d \n", smsc_len);
    if (smsc_len > 0) {
	/* Type of Address */
        strncpy(buf, pdu+2, sizeof(buf) - 1);
        buf[2] = '\0';	
        smsc_toa = gsm_hex2int(buf);
        if (gsm->debug)
	    gsm_message(gsm, "smsc_toa = %#x \n", smsc_toa);	

	/* SMSC Number (decimal semi octets) */
        strncpy(buf, pdu+4, sizeof(buf) - 1);
        buf[(smsc_len-1)*2] = '\0';
	strncpy(smsc_number_dso, buf, sizeof(smsc_number_dso)-1);	

	gsm_convertNumber(smsc_number, smsc_number_dso, smsc_len, smsc_toa);
        if (gsm->debug)
	    gsm_message(gsm, "smsc_number = %s \n", smsc_number);
	strncpy(gsm->ev.sm_received.smsc, smsc_number, sizeof(gsm->ev.sm_received.smsc)-1);	
    } else {
	gsm->ev.sm_received.smsc[0] = '\0';
    }

    /* Address length */
    strncpy(buf, pdu+(smsc_len*2+4), sizeof(buf) - 1);
    buf[2] = '\0';	
    sender_len = gsm_hex2int(buf);
    if (gsm->debug)
	gsm_message(gsm, "sender_len = %d \n", sender_len);	

    if (sender_len > 0) {
	/* Type of address */
        strncpy(buf, pdu+(smsc_len*2+6), sizeof(buf) - 1);
        buf[2] = '\0';	
        sender_toa = gsm_hex2int(buf);
        if (gsm->debug)
	    gsm_message(gsm, "sender_toa = %#x \n", sender_toa);		

	/* Address number (decimal semi octets) */
        strncpy(buf, pdu+(smsc_len*2+8), sizeof(buf) - 1);
	buf[sender_len+1] = '\0';
	if (sender_len % 2) {
    	    /* odd */
	    sender_len++;
	}
	strncpy(sender_number_dso, buf, sizeof(sender_number_dso)-1);	
	gsm_convertNumber(sender_number, sender_number_dso, sender_len, sender_toa);
        if (gsm->debug)
	    gsm_message(gsm, "sender_number = %s \n", sender_number);
	strncpy(gsm->ev.sm_received.sender, sender_number, sizeof(gsm->ev.sm_received.sender)-1);	
    } else {
	gsm->ev.sm_received.sender[0] = '\0';
    }
    
    strncpy(buf, pdu+(smsc_len*2)+sender_len+8, sizeof(buf) - 1);
    buf[2] = '\0';	
    pid = gsm_hex2int(buf);
    if (gsm->debug)
	gsm_message(gsm, "protocol identifier = %#x \n", pid);		

    strncpy(buf, pdu+(smsc_len*2)+sender_len+10, sizeof(buf) - 1);
    buf[2] = '\0';	
    dcs = gsm_hex2int(buf);
    if (gsm->debug)
	gsm_message(gsm, "data coding scheme = %#x \n", dcs);		

    strncpy(buf, pdu+(smsc_len*2)+sender_len+12, sizeof(buf) - 1);
    buf[14] = '\0';	
    strncpy(timestamp_dso, buf, sizeof(timestamp_dso)-1);	
    gsm_dso2string(timestamp, timestamp_dso, 14);
    if (gsm->debug)
	gsm_message(gsm, "timestamp = %s \n", timestamp);		

    strncpy(buf, pdu+(smsc_len*2)+sender_len+26, sizeof(buf) - 1);
    buf[2] = '\0';	
    udl = gsm_hex2int(buf);
    if (gsm->debug)
	gsm_message(gsm, "user data length = %d \n", udl);		
    gsm->ev.sm_received.len = udl;

    strncpy(buf, pdu+(smsc_len*2)+sender_len+28, sizeof(buf) - 1);
    buf[udl*2] = '\0';
    strncpy(user_data, buf, sizeof(user_data)-1);	
    if (gsm->debug)
	gsm_message(gsm, "user_data = %s \n", user_data);
    
    gsm_string2byte(user_data_7bit, user_data, udl);
    gsm_to8Bit(user_data_7bit, user_data_8bit, udl);
    if (gsm->debug)
	gsm_message(gsm, "user_data_8bit = %s \n", user_data_8bit);
    if (!udl) {
	gsm->ev.sm_received.text[0] = '\0';
    } else {
	strncpy(gsm->ev.sm_received.text, (char *)user_data_8bit, sizeof(gsm->ev.sm_received.text)-1);	
    }

    return 0;
}


