/**
 *
 * ISDNguard Service Daemon
 * 
 * Copyright (C) 2005, Junghanns.NET GmbH
 *
 * Klaus-Peter Junghanns <kpj@junghanns.net>
 *
 * large parts taken from pbx_wilcalu.c (Asterisk)
 *
 * Copyright (C) 1999, Mark Spencer
 * Mark Spencer <markster@digium.com>
 *
 * This program is free software, distributed under the terms of
 * the GNU General Public License
 *
 */

#include <unistd.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/poll.h>
#include <sys/time.h>
#include <errno.h>
#include <pthread.h>

#define AST_RUN_DIR "/var/run/"
#define	PTHREAD_ATTR_STACKSIZE		2097152
#define SLEEPTIME 400000
#define MAX_DELAY SLEEPTIME * 2

static  pthread_t heartbeat_thread;
static  char buf[257];
static  char lastbuf[257]; /* contains last partial buffer */
static  char sendbuf[257];
static	char fifoname[256];
static	char devicename[256];
static	pthread_mutex_t lock = PTHREAD_MUTEX_INITIALIZER;
static	struct timeval lastping;
static	int isarmed = 1;

static void *listen()
{
	char * sendbufptr=sendbuf;
	int fd=open(fifoname,O_RDONLY|O_NONBLOCK);
	struct pollfd fds[1];
	int s;
	
	if(fd<0) {
		printf("guard: unable to open fifo\n");
		pthread_exit(NULL);
	}
	memset(buf,0,257);
	memset(lastbuf,0,257);
	memset(sendbuf,0,257);
	while(1){
		ssize_t bytes;

		memset(buf,0,257);
		fds[0].fd = fd;
		fds[0].events = POLLIN;
	        fds[0].revents = 0;
		s = poll(fds, 1, -1);
		if (!(fds[0].revents & POLLIN)) {
		    close(fd);
		    fd=open(fifoname,O_RDONLY|O_NONBLOCK);
		    continue;
		} 
		
		bytes=read(fd,buf,256);
		buf[(int)bytes]=0;

		if(bytes>0){
			int x;
			sendbufptr=sendbuf;
			for(x=0; lastbuf[x]!=0 && x<257; x++);
			if(x) {
				memcpy(sendbuf, lastbuf, x);
				sendbufptr+=x;
				memset(lastbuf, 0, 257);
			}
			/* Process bytes read */
			for(x=0; x<bytes; x++){
				/* if \n then string is complete */
				if(buf[x]=='\n'){
					if (!strncmp(sendbuf, "PING", sizeof(sendbuf))) {
					    pthread_mutex_lock(&lock);
					    gettimeofday(&lastping, NULL);
					    pthread_mutex_unlock(&lock);						    
					} else if (!strncmp(sendbuf, "AUTO", sizeof(sendbuf))) {
					    pthread_mutex_lock(&lock);
					    isarmed = 0;
					    pthread_mutex_unlock(&lock);						    
					} else if (!strncmp(sendbuf, "STOP", sizeof(sendbuf))) {
					    pthread_mutex_lock(&lock);
					    isarmed = 2;
					    pthread_mutex_unlock(&lock);						    
					} else if (!strncmp(sendbuf, "START", sizeof(sendbuf))) {
					    pthread_mutex_lock(&lock);
					    isarmed = 1;
					    pthread_mutex_unlock(&lock);
					}
					sendbufptr=sendbuf;
					memset(sendbuf, 0, 257);
				} else {
					if(buf[x]=='\n')
						continue;
					*sendbufptr=buf[x];
					sendbufptr++;
					*sendbufptr=0;
				}
			}
			if(sendbufptr!=sendbuf)
				memcpy(lastbuf, sendbuf, sendbufptr-sendbuf+1);
		}
	}
	close(fd);
	pthread_exit(NULL);
	return NULL;
}

static void *heartbeat(void *ignore)
{
	char command[10];
	int fd = -1;
	unsigned long dusec = 0;
	fd = open(devicename, O_WRONLY | O_SYNC);
	struct timeval nowtime;
	while(1){
	    gettimeofday(&nowtime, NULL);
	    pthread_mutex_lock(&lock);
	    dusec = (nowtime.tv_sec - lastping.tv_sec) * 1000000;
	    dusec += (nowtime.tv_usec - lastping.tv_usec); 
	    snprintf((char *)command, sizeof(command), "_%d", (int) nowtime.tv_sec + (int) dusec);
	    switch (isarmed) {
		case 0:
		    write(fd, command, sizeof(command));
		    break;
		case 1:
		    if (dusec <= MAX_DELAY) {
			write(fd, command, sizeof(command));
		    }
		    break;
	    }
	    pthread_mutex_unlock(&lock);
	    usleep(SLEEPTIME);
	}
	close(fd);
	pthread_exit(NULL);
}


int main(int argc, char *argv[])
{
	int res;
	pthread_attr_t *attr;
	pthread_attr_t lattr;
	
	if (argc < 2) {
	    printf("\nUsage: guard <device> [AUTO|STOP]\n\n");
	    return(0);
	} 
	
	snprintf((char *)fifoname, sizeof(fifoname), "%s/%s", AST_RUN_DIR, "guard.ctl");
	res = mkfifo(fifoname, 0700);
	if (res) {
	    if(errno != EEXIST){
		printf("Error creating fifo!\n");
		return 0;
	    }
	}

	lastping.tv_sec = 0;
	lastping.tv_usec = 0;
	
	if (argc > 2) {
	    if (!strncmp("AUTO", argv[2], sizeof(argv[2]))) {
		isarmed = 0;
	    } else if (!strncmp("STOP", argv[2], sizeof(argv[2]))) {
		isarmed = 2;
	    }
	}
	pthread_attr_init(&lattr);
	attr = &lattr;
	errno = pthread_attr_setstacksize(attr, PTHREAD_ATTR_STACKSIZE);
	if (errno) {
	    printf("pthread_attr_setstacksize returned non-zero: %s\n", strerror(errno));
	}
	snprintf((char *)devicename, sizeof(devicename), "%s", argv[1]);
	pthread_create(&heartbeat_thread, attr, heartbeat, NULL); 
	listen();
	return 0;
}

