#!/bin/bash
wget http://www.asterisk-support.de/mirror/zaptel/zaptel-1.2.27.tar.gz
wget http://www.asterisk-support.de/mirror/libpri/libpri-1.2.8.tar.gz
#wget http://www.asterisk-support.de/mirror/asterisk-1.2.34/asterisk-1.2.34.tar.gz
wget http://downloads.asterisk.org/pub/telephony/asterisk/old-releases/asterisk-1.2.34.tar.gz
wget http://www.asterisk-support.de/mirror/asterisk-addons/asterisk-addons-1.2.8.tar.gz
gzip -d ./*.gz

tar -xf zaptel-1.2.27.tar
tar -xf libpri-1.2.8.tar
tar -xf asterisk-1.2.34.tar

mkdir -p addons
mv asterisk-addons-1.2.8.tar ./addons
cd ./addons
tar -xf asterisk-addons-1.2.8.tar
ln -s ../asterisk/include asterisk
cd ..

ln -s zaptel-1.2.27 zaptel
ln -s asterisk-1.2.34 asterisk
ln -s libpri-1.2.8 libpri
ln -s libgsmat-0.0.4 libgsmat


sh apply-patches.sh zaptel patches/zaptel
sh apply-patches.sh libpri patches/libpri
sh apply-patches.sh asterisk patches/asterisk

sh apply-patches.sh addons/asterisk-addons-1.2.8 ../patches/addons

cd zaptel
ln -sf ../cwain/cwain.[ch] ../qozap/qozap.[ch] ../zaphfc/zaphfc.[ch] ../ztgsm/ztgsm.[ch] .
cd ..

echo "****************************************************"
echo "         Downloading and patching finished."
echo "****************************************************"
