#!/bin/sh
# Emulate 'quilt push -a'
# $1 source directory
# $2 patch directory - a relative path.
set -e

patches_dir="$PWD/$2"
patches_list="$patches_dir/series"

cd "$1"
for patch_name in  `sed  -e 's/#.*$//' $patches_list` ; do
	patch_file="$patches_dir/$patch_name"
	if ! patch -p1 < "$patch_file" --quiet --dry-run; then
		echo "Failed applying $patch_file (directory: $2).  Aborting."
		exit 1
	fi
	patch -p1 < "$patch_file"
done
