#!/bin/sh



# let's expose problems:
set -e

ZAP_VER=1.2.27
BRISTUFF_ZAP_MODS="${BRISTUFF_ZAP_MODS:-cwain qozap zaphfc ztgsm}"

# remove old dir if run again
rm -rf zaptel-${ZAP_VER}

wget http://www.asterisk-support.de/mirror/zaptel/zaptel-${ZAP_VER}.tar.gz

tar -xzf zaptel-${ZAP_VER}.tar.gz
ln -s zaptel-${ZAP_VER} zaptel

./apply-patches.sh zaptel patches-zaptel-1.2/zaptel

# pretend those drivers are in the zaptel directory:
cd zaptel
ln -sf ../cwain/cwain.[ch] ../qozap/qozap.[ch] ../zaphfc/zaphfc.[ch] ../ztgsm/ztgsm.[ch] .
cd ../

if [ "$KVERS" != '' ]; then
	BRISTUFF_ZAP_PARAMS="$BRISTUFF_ZAP_PARAMS KVERS=$KVERS"
fi

if [ "$KSRC" != '' ]; then
	BRISTUFF_ZAP_PARAMS="$BRISTUFF_ZAP_PARAMS KSRC=$KSRC"
fi

if [ -d zaptel ]; then
	cd zaptel
	make MODULES_EXTRA="$BRISTUFF_ZAP_MODS" $BRISTUFF_ZAP_PARAMS clean
	make MODULES_EXTRA="$BRISTUFF_ZAP_MODS" $BRISTUFF_ZAP_PARAMS all
	make MODULES_EXTRA="$BRISTUFF_ZAP_MODS" $BRISTUFF_ZAP_PARAMS install
	cd ..
	echo "ZAPTEL installed"
fi


if [ "x86_64" = "`uname -p`" ]
then
    echo "Installing voip-mg 64bit version"
    VOIPMG=voip-mg.zaptel-1.2.x86_64
else
    echo "Installing voip-mg 32bit version"
    VOIPMG=voip-mg.zaptel-1.2.x86
fi

mkdir -p /opt/voip-mg
cp -f ./voip-mg/$VOIPMG /opt/voip-mg/voip-mg

if [ -f /opt/voip-mg/config.db ]
then
    echo "Keeping existing configuration"
else
    echo "Installing default configuration (webinterface on port 18080)"
    cp -f ./voip-mg/config.db /opt/voip-mg/
fi

echo "Installing webinterface"

mkdir -p /opt/voip-mg/htdocs
cp -rf ./voip-mg/web/* /opt/voip-mg/htdocs/

echo "Installation finished"
