/**
 * @author admin
 */

    App.ux.FormPanelActionURLs = Ext.extend(Ext.form.FormPanel, {
        // private vars
        initComponent: function()
        {
            //default/alterable configurables 
            var cfg = {
                border: false,
                method: 'GET',
				errorReader:new Ext.form.XmlErrorReader(),
                url: '../../xml/configuration?action=view&key=sms_received_url',
                reader: new Ext.data.XmlReader({
                    record: 'configuration',
                    success: '@success'
                }, [{
                    name: 'value',
                    mapping: 'sms_received_url',
                    type: 'string'
                }]),
                items: [ {
                    xtype: 'fieldset',
                    autoHeight: true,
                    layout: 'column',
                    title: 'Action-URLs',
                    items: [{
                        columnWidth: 0.6,
                        border: false,
                        style: 'margin-right:5px;',
                        layout: 'form',
                        items: [{
                            xtype: 'textfield',
                            name: 'value',
                            fieldLabel: 'SMS received'
                        }]
                    }, {
                        columnWidth: 0.4,
                        layout: 'form',
                        border: false,
                        items: [{
                            xtype: 'button',
                            text: 'Save',
                            handler: this.saveSettings,
                            scope: this
                        }]
                    }]
                }]
            };
            
            Ext.applyIf(this, cfg);
            Ext.applyIf(this.initialConfig, cfg);
            
            //non-alterable configurables 
            cfg = {};
            Ext.apply(this, cfg);
            Ext.apply(this.initialConfig, cfg);
            
            App.ux.FormPanelActionURLs.superclass.initComponent.apply(this, arguments);
            
        }, // eo function initComponent 
        onRender: function(container, position)
        {
            App.ux.FormPanelActionURLs.superclass.onRender.apply(this, arguments);
            // after parent code
            // bind a few useful events to handle row selection, and context menu
            //this.on('contextmenu', this.showContextMenu, this);
            // general buttons
            //this.getForm().load();
        },
        onShow: function()
        {
            App.ux.FormPanelActionURLs.superclass.onShow.apply(this, arguments);
            this.getForm().load();
        },
        saveSettings: function()
        {
            this.getForm().submit({
                url: '../../xml/configuration?action=update&key=sms_received_url',
                method: 'GET',
                scope: this,
				customSuccessFn:function(xml,scope)
				{
					var form = scope.getForm();
					   form.load();                    
                        App.showMessage('ActionURL were saved.'); // 2 DO bubble message which disappears after a while? 
				}
            });
        }
    });
    /*
     * Register xtype
     */
    Ext.ComponentMgr.registerType('ux-formpanelactionurls', App.ux.FormPanelActionURLs); //convention is to use all lowercase for xtype



















