App.ux.FormPanelPortWebinterface = Ext.extend(Ext.form.FormPanel, {
        // private vars
        initComponent: function()
        {
            //default/alterable configurables 
            var cfg = {
                border: false,
                method: 'GET',
				trackResetOnLoad:true,
				errorReader:new Ext.form.XmlErrorReader(),
                url: '../../xml/configuration?action=view&key=http_bind_port',
                reader: new Ext.data.XmlReader({
                    record: 'configuration',
                    success: '@success'
                }, [{
                    name: 'value',
                    mapping: 'http_bind_port',
                    type: 'string'
                }]),
                items: [ {
                    xtype: 'fieldset',
                    autoHeight: true,
                    layout: 'column',
                    title: 'Change Webinterface HTTP port',
                    items: [{
                        columnWidth: 0.6,
                        border: false,
                        style: 'margin-right:5px;',
                        layout: 'form',
                        items: [{
                            xtype: 'textfield',
							allowBlank:false,
                            name: 'value',
                            fieldLabel: 'HTTP port'
                        }]
                    }, {
                        columnWidth: 0.4,
                        layout: 'form',
                        border: false,
                        items: [{
                            xtype: 'button',
							iconCls:'icon-disk',
                            text: 'Change Port',
                            handler: this.saveSettings,
                            scope: this
                        }]
                    }]
                }]
            };
            
            Ext.applyIf(this, cfg);
            Ext.applyIf(this.initialConfig, cfg);
            
            //non-alterable configurables 
            cfg = {};
            Ext.apply(this, cfg);
            Ext.apply(this.initialConfig, cfg);
            
            App.ux.FormPanelPortWebinterface.superclass.initComponent.apply(this, arguments);
            
        }, // eo function initComponent 
        onRender: function(container, position)
        {
            App.ux.FormPanelPortWebinterface.superclass.onRender.apply(this, arguments);
            // after parent code
            // bind a few useful events to handle row selection, and context menu
            //this.on('contextmenu', this.showContextMenu, this);
            // general buttons
            //this.getForm().load();
        },
        onShow: function()
        {
            App.ux.FormPanelPortWebinterface.superclass.onShow.apply(this, arguments);
            this.getForm().load();
        },
        saveSettings: function()
        {
			if(this.getForm().isValid() === false)
			{
				return false;
			}
			
            this.getForm().submit({
                url: '../../xml/configuration?action=update&key=http_bind_port',
                method: 'GET',
                scope: this,
                customSuccessFn:function(xml,scope)
                {
					console.log(scope);
                    var form = scope.getForm();
                    form.load();                    
                    App.showMessage('HTTP-Port was changed.');
                }
            });
        }
    });
    /*
     * Register xtype
     */
    Ext.ComponentMgr.registerType('ux-formpanelportwebinterface', App.ux.FormPanelPortWebinterface); //convention is to use all lowercase for xtype






