
    App.ux.GridDebug = Ext.extend(Ext.grid.GridPanel, {
        // private vars     
        runner: new Ext.util.TaskRunner(),
        updateTask: {
            run: function()
            {
                //Ext.StoreMgr.lookup('storeDebug').load({method:'GET'});
            },
            interval: 5000,
            scope: this
        },
        runnerFlag: false,
        selModel: new Ext.grid.RowSelectionModel({
            singleSelect: true
        }),
        store: new Ext.data.Store({
            storeId: 'storeDebug',
            // load using HTTP
            proxy: new Ext.data.HttpProxy({
                url: '../../xml/trace?action=list',
                method: 'GET'
            }),
            // the return will be XML, so lets set up a reader
            reader: new Ext.data.XmlReader({
                // records will have an "Item" tag
                record: 'frame',
                id: 'id'
                //totalRecords: '@total'
            }, ['id', 'span', 'channel', 'sapi', 'c_r', 'ea0', 'tei', 'ea1', 'frame_type', 'command', 'm3', 'p_f', 'm2', 'frametype', 'protocol_discriminator', 'message_type', 'reference_number', 'action_indicator'])
        }), // eo store
        // renderer functions
        renderActivationStatus: function(data)
        {
            switch (data) {
                case 0:
                    return "Not activated yet.";
                    break;
                case 1:
                    return '<img src="images/icons/accept.png" class="iconCell"> Activated.';
                    break;
                case 2:
                    return "Too many activations. Please contact Junghanns.NET Support!";
                    break;
                case 3:
                    return '<img src="images/icons/error.png" class="iconCell">Calls-Key is not valid.';
                    break;
            }
        },
        initComponent: function()
        {
        
            // rendering functions
            
            //default/alterable configurables 
            var cfg = {
				 enableCtxMenu: false,
                hideMode: 'offsets',
                selModel: new Ext.grid.RowSelectionModel({
                    singleSelect: true
                }),
				 enableColumnHide:false,
                tbar: new Ext.Toolbar({
                    items: [{
                        xtype: 'button',
                        text: 'Refresh',
						iconCls:'icon-table_refresh',
                        handler: function()
                        {
                            Ext.StoreMgr.lookup('storeDebug').reload({
                                method: 'GET'
                            });
                        }
                    }, {
                        xtype: 'button',
                        text: 'Clear view',
						iconCls:'icon-cross',
                        handler: function()
                        {
                            Ext.Ajax.request({
                                url: '../../xml/tracer?action=clear',
                                method: 'GET'
                            });
                            while (Ext.getCmp('debugInformation').getRootNode().firstChild) 
                            {
                                var c = Ext.getCmp('debugInformation').getRootNode().firstChild;
                                Ext.getCmp('debugInformation').getRootNode().removeChild(c);
                                c.destroy();
                            }
                            
                            Ext.StoreMgr.lookup('storeDebug').reload({
                                method: 'GET'
                            });
                        }
                    }]
                }),
                store: this.store,
                columns: [{
                    header: "ID",
                    width: 50,
                    dataIndex: 'id',
                    sortable: true
                }, {
                    header: "timestamp",
                    width: 100,
                    dataIndex: 'timestamp',
                    sortable: true
                }, {
                    header: "span",
                    width: 100,
                    dataIndex: 'span',
                    sortable: true
                }]
            };
            
            Ext.applyIf(this, cfg);
            Ext.applyIf(this.initialConfig, cfg);
            
            //non-alterable configurables 
            cfg = {enableColumnHide:false};
            Ext.apply(this, cfg);
            Ext.apply(this.initialConfig, cfg);
            
            App.ux.GridDebug.superclass.initComponent.apply(this, arguments);
            
        }, // eo function initComponent 
        onRender: function(container, position)
        {
            App.ux.GridDebug.superclass.onRender.apply(this, arguments);
            // after parent code
            // bind a few useful events to handle row selection, and context menu
            //this.on('contextmenu', this.showContextMenu, this);
        
            // general buttons
        
        
        
        
        }, // end of function onRenderLayout().setActiveItem(this.step);
        startUpdater: function()
        {
            if (this.runnerFlag == false)
            {
                this.runner.start(this.updateTask);
                this.runnerFlag = true;
                
            }
        },
        stopUpdater: function()
        {
            if (this.runnerFlag == true) 
            {
                this.runner.stop(this.updateTask);
                this.runnerFlag = false;
            }
        }
        // Add Calls Key window/form
    }); // end of extend
    /*
     * Register xtype
     */
    Ext.ComponentMgr.registerType('ux-griddebug', App.ux.GridDebug); //convention is to use all lowercase for xtype
