    App.ux.GridLicense = Ext.extend(Ext.grid.GridPanel, {
        // private vars       
        store: new Ext.data.Store({
            storeId: 'storeLicenses',
            autoLoad: false,
            proxy: new Ext.data.HttpProxy({
                url: '../../xml/licenses?action=list',
                method: 'GET',
                listeners: {
                    'beforerequest': {
                        fn: function(con, opt)
                        {
                            Ext.get(document.body).mask("loading...");
                        },
                        scope: this
                    }
                }
            }),
            reader: new Ext.data.XmlReader({
                record: 'license',
                id: 'ID'
            }, [{
                name: 'ID',
                type: 'int'
            }, {
                name: 'key',
                type: 'string'
            }, {
                name: 'token',
                type: 'string'
            }, {
                name: 'status',
                type: 'int'
            }, {
                name: 'description',
                type: 'string'
            }])
        }), // eo store
        // renderer functions
        renderActivationStatus: function(data)
        {
            switch (data) {
                case 0:
                    return "Not activated yet.";
                    break;
                case 1:
                    return '<img src="images/icons/accept.png" class="iconCell"> Activated.';
                    break;
                case 2:
                    return "Too many activations. Please contact Junghanns.NET Support!";
                    break;
                case 3:
                    return '<img src="images/icons/error.png" class="iconCell">License-Key is not valid.';
                    break;
            }
        },
        renderType: function(data)
        {
            if (data == "(null)") 
                return "";
            return data;
        },
        
        initComponent: function()
        {
        
            // rendering functions
            
            //default/alterable configurables 
            var cfg = {
				 enableColumnHide:false,
                 enableCtxMenu: false,
                hideMode: 'offsets',
                selModel: new Ext.grid.RowSelectionModel({
                    singleSelect: true
                }),
                store: this.store,
                tbar: [{
                    id: 'btnAddLicense',
                    text: 'Add License key',
                    iconCls: 'iconAdd',
                    handler: this.addLicenseKey,
                    scope: this
                }, {
                    id: 'btnDeleteLicense',
                    text: 'Delete License key',
                    iconCls: 'iconDelete',
                    handler: this.deleteLicenseKey,
                    scope: this
                }, {
                    id: 'btnActivateLicenses',
                    text: 'Activate license keys',
                    handler: this.activateLicenseKey,
                    scope: this,
                    iconCls: 'iconLicense'
                }],
                columns: [{
                    header: 'License-Key',
                    width: 160,
                    dataIndex: 'key',
                    sortable: 'true'
                }, {
                    header: 'Type',
                    width: 280,
                    dataIndex: 'description',
                    sortable: true,
                    renderer: this.renderType
                }, {
                    header: 'Activation-Status',
                    width: 180,
                    dataIndex: 'status',
                    sortable: true,
                    renderer: this.renderActivationStatus
                }]
            };
            
            Ext.applyIf(this, cfg);
            Ext.applyIf(this.initialConfig, cfg);
            
            //non-alterable configurables 
            cfg = {
                viewConfig: {
                    forceFit: true,
                    autoFill: true
                },
				enableColumnHide:false
            };
            Ext.apply(this, cfg);
            Ext.apply(this.initialConfig, cfg);
            
            App.ux.GridLicense.superclass.initComponent.apply(this, arguments);
            
        }, // eo function initComponent 
        onRender: function(container, position)
        {
            App.ux.GridLicense.superclass.onRender.apply(this, arguments);
            // after parent code
            // bind a few useful events to handle row selection, and context menu
            //this.on('contextmenu', this.showContextMenu, this);
            
            // general buttons
            
            
        }, // end of function onRenderLayout().setActiveItem(this.step);
        // Add License Key window/form
        addLicenseKey: function()
        {
        
            App.winAddLicenseKey = new Ext.Window({
                title: 'Add license key',
                modal: 'true',
                layout: 'fit',
                plain: true,
                width: 400,
                height: 120,
                items: [{
                    xtype: 'form',
                    id: 'formAddLicenseKey',
                    waitMsgTarget: true,
                    errorReader: new Ext.form.XmlErrorReader(),
                    buttonAlign: 'center',
                    baseCls: 'x-plain',
                    labelWidth: 70,
                    bodyStyle: 'padding:10px;',
                    items: [{
                        xtype: 'textfield',
                        name: 'key',
                        anchor: "90%",
                        fieldLabel: 'License key',
						allowBlank:false
                    }],
                    buttons: [{
                        text: 'Add key',
                        handler: function()
                        {
                            console.log(this);
                            this.ownerCt.getForm().submit({
                                url: '../../xml/licenses?action=insert',
                                method: 'GET',
                                waitMsg: 'Processing data...', // 2DO
                                customSuccessFn: function()
								{
									App.winAddLicenseKey.close();
									App.showMessage('License key was added successfully.');
									Ext.StoreMgr.lookup('storeLicenses').load();
								}
                            });
                        }
                    }, {
                        text: 'Cancel',
                        handler: function()
                        {
                            App.winAddLicenseKey.close();
                        }
                    }]
                }]
            })
          App.winAddLicenseKey.show();
            
        }, // eo addLicenseKey
        deleteLicenseKey: function()
        {
            var rec = this.getSelectionModel().getSelected();
			
			if(rec == undefined)
			{
				App.showError("You have to select a license key to delete.");
				return false;
			}
			
            var id = rec.get('ID');
            
            Ext.Ajax.request({
                url: '../../xml/licenses?action=delete&ID=' + id,
                method: 'GET',
				customSuccessFn:function(){
					App.showMessage('The license key was deleted.');
                    Ext.StoreMgr.lookup('storeLicenses').load();
				}
            });
        },
        activateLicenseKey: function()
        {
            var records = Ext.StoreMgr.lookup('storeLicenses').query('status', /[023]/); // returns Ext.util.MixedCollection
			records.each(function(item, index, length)
            {
				console.log('Activating license key',item);
				
                Ext.Ajax.request({
                    waitMsg: 'Activating key...',
                    url: '../../xml/licenses?action=activate&ID=' + item.data.ID,
                    method: 'GET',
					customSuccessFn:function(){
						Ext.StoreMgr.lookup('storeLicenses').reload();
						App.showMessage('License-key activation was successfull.');	
					},
					customFailureFn:function(){
						Ext.StoreMgr.lookup('storeLicenses').reload();
					}
                });
            }, this);
        }
    }); // end of extend
    /*
     * Register xtype
     */
    Ext.ComponentMgr.registerType('ux-gridlicense', App.ux.GridLicense); //convention is to use all lowercase for xtype
   
