App.ux.treeLoaderDebug = Ext.extend(Ext.tree.TreeLoader, {
    /**
     * @property  XML_NODE_ELEMENT
     * XML element node (value 1, read-only)
     * @type Number
     */
    XML_NODE_ELEMENT : 1,
    /**
     * @property  XML_NODE_TEXT
     * XML text node (value 3, read-only)
     * @type Number
     */
    XML_NODE_TEXT : 3,
    
    // private override
    processResponse : function(response, node, callback){

		var xmlData = response.responseXML;
        var root = xmlData.documentElement || xmlData;
	
		var dataset = Ext.DomQuery.selectNode('frames',root);
		
		console.log(dataset,'- our dataset');
		console.log('- now we parse data');
		
		var nodes = this.parseXml(dataset);
		
			node.beginUpdate();
            node.appendChild(nodes);
            node.endUpdate();
			if (typeof callback == "function") 
			{
				callback(this, node);
			}
		
        /*try{
            node.beginUpdate();
            node.appendChild(this.parseXml(dataset));
            node.endUpdate();
            
            if(typeof callback == "function"){
                callback(this, node);
            }
        }catch(e){
            this.handleFailure(response);
        }*/
    },
    
    // private
    parseXml : function(node) {
		
		var dq = Ext.DomQuery;

        var nodes = []; // array for nodes, which will be returned to tree
		var i = 0;
		// check all childnodes for this node
		Ext.each(node.childNodes, function(n){
			
			if(n.nodeType == 1)
			{
				var treeNode = this.createNode(n);
				
				// looking out for children
				if (n.childNodes.length > 0) 
				{
					var child = this.parseXml(n);
					if (typeof child != 'string') 
					{
						treeNode.appendChild(child);
					}
				}
				nodes.push(treeNode);
			}
			i++;
			},this);

		
		return nodes;
    },
    
    // private override
    createNode : function(node){
        var attr = {
            tagName: node.tagName,
			text:node.tagName,
			loaded:true // because we loaded whole damn xml
        };
		
		// no children, so we add value
		if (node.childNodes.length == 1) 
		{
			attr.text = node.tagName + ' : ' + node.childNodes[0].nodeValue;
		}
		/*
        Ext.each(node.attributes, function(a){
            attr[a.nodeName] = a.nodeValue;
        });
		*/
		// save document information (which is in child tags)
       /* if (node.tagName == 'document') 
        {
            Ext.each(node.childNodes, function(child)
            {
                if (child.nodeValue != "\n") 
                {
                    attr['' + child.nodeName] = Ext.DomQuery.selectValue(child.nodeName,node);
                }
            });
        }*/
		// eo save document information
		
        //this.processAttributes(attr);
        
        return App.ux.treeLoaderDebug.superclass.createNode.call(this, attr);
    },
    
    /*
     * Template method intended to be overridden by subclasses that need to provide
     * custom attribute processing prior to the creation of each TreeNode.  This method
     * will be passed a config object containing existing TreeNode attribute name/value
     * pairs which can be modified as needed directly (no need to return the object).
     */
    processAttributes : function(attr){
       	
		attr.text = attr.title; // set title attribute to be text for node/leaf
		
	   // directory node
	    if(attr.tagName == "directory"){ // is it directory node?
            
            // Override these values for our folder nodes because we are loading all data at once.  If we were
            // loading each node asynchronously (the default) we would not want to do this:
            attr.loaded = true;
            //attr.expanded = true;
        }
		
		// document node
		if(attr.tagName == "document")
		{
			attr.leaf = true; // define as leaf
			// 2DO icon by filetype:
			switch(attr.docType)
			{
				case "pdf":
					attr.iconCls='pdf';
					break;
				case "odt":
					attr.iconCls='txt';
					break;
				case "txt":
					attr.iconCls='txt';
					break;
				case "doc":
					attr.iconCls='doc';
					break;
				case "png":
					attr.iconCls='image';
					break;
				case "jpg":
					attr.iconCls='image';
					break;
				case "jpeg":
					attr.iconCls='image';
					break;
				case "gif":
					attr.iconCls='image';
					break;
				default:
					break;
			}
			
		}
    }

});
