App.ux.AppLoader = function()
{
    var Application = null;
    // public space
    return {
		/*
	 	* Init-Function
	 	*/
		init: function(moduleName, ApplicationFn)
		{
			// 2DO: no ApplicationFn	
			console.log('init App.AppLoader');
			Application = ApplicationFn;
			// check session key first
			this.sessionKeyCheck();
		},
		/* check session key */
		sessionKeyCheck:function(){
			console.log('App.AppLoader: SessionKey check');
			
			App.getVarsFromUrl(location.search); // get vars and write the to App.urlParams
			// check the "session"-parameter
			if (typeof(App.urlParams.session) != 'undefined' || App.urlParams.session === "") 
			{
				 App.sessionKey = App.urlParams.session;
				// set session key as extra param for all actions
				Ext.data.Connection.extraParams={'session':App.sessionKey};
				Ext.Ajax.extraParams={'session':App.sessionKey};
				
				console.log('App.ux.AppLoader: Session parameters are there.');
				this.checkLanguageAfterLogin();		
			}
			// keycheck failed -> login
			else
			{
				console.log('App.AppLoader: SessionCheck was not successfull.');
				this.showLoginWindow();
			} // eo keycheck failed
			
		}, // eo sessionKeyCheck
		showLoginWindow:function(){
			console.log('App.AppLoader: show login window');
			
			var f = new App.ux.FormPanelLogin({region:'center'});
			
			var win = new Ext.Window({
				width:350,
				height:170,
				items:[f],
				layout:'border',
				title:'Junghanns.NET voip-mg login',
				closable:false
			});
		
			win.show();
			
		},// eo showLoginWindow
		/* check if session language is the same as user language */
		checkLanguageAfterLogin:function(){
			console.log('App.AppLoader: checking language-properties');
			
			// 2DO
			
			this.startApplication();
			
		}, // eo checkLanguageAfterLogin
		startApplication:function(){
			console.log('App.AppLoader:AppLoader finished,starting Application');
			Application();
		}
	}; // eo return
};