App.ux.ComboBoxCountries = Ext.extend(Ext.form.ComboBox, {
    // private vars
    initComponent: function()
    {
        // rendering functions
        
        //default/alterable configurables 
        var cfg = {
                    xtype: 'combo',
                    fieldLabel: 'Country',
                    name: 'spanCountry',
                    hiddenName: 'country',
                    valueField: 'countrycode',
                    displayField: 'name',
                    editable: false,
                    //mode: 'local',
                    forceSelection: true,
                    triggerAction: 'all',
                    emptyText: '-',
                    //disableKeyFilter: true,
                    //selectOnFocus: true,
                    store: new Ext.data.Store({
                       // storeId: 'storeCountries',
                        proxy: new Ext.data.HttpProxy({
                            url: '../../xml/spans?action=countries',
                            method: 'GET'
                        }),
                        reader: new Ext.data.XmlReader({
                            record: 'country'
                        }, [{
                            name: 'countrycode',
                            type: 'int'
                        }, {
                            name: 'name',
                            type: 'string'
                        }])
                    })
        };
        
        Ext.applyIf(this, cfg);
        Ext.applyIf(this.initialConfig, cfg);
        
        //non-alterable configurables 
        cfg = {};
        Ext.apply(this, cfg);
        Ext.apply(this.initialConfig, cfg);
        
        App.ux.ComboBoxCountries.superclass.initComponent.apply(this, arguments);
        
    }, // eo function initComponent 
    onRender: function(container, position)
    {
        App.ux.ComboBoxCountries.superclass.onRender.apply(this, arguments);
        // after parent code
        // bind a few useful events to handle row selection, and context menu
        //this.on('contextmenu', this.showContextMenu, this);
        // general buttons
		
		
		this.store.load();
		
    }
});
/*
 * Register xtype
 */
Ext.ComponentMgr.registerType('ux-comboboxcountries', App.ux.ComboBoxCountries); //convention is to use all lowercase for xtype














