App.ux.FormPanelChangePassword = Ext.extend(Ext.form.FormPanel, {
    // private vars
    initComponent: function()
    {
        // rendering functions
        
        //default/alterable configurables 
        var cfg = {
			errorReader:new Ext.form.XmlErrorReader(),
            border: false,
            //anchor:'100% 40%',
            items: [{
                xtype: 'fieldset',
                autoHeight: true,
                title: 'Change password',
                defaults: {
                    allowBlank: false
                },
                items: [{
                    xtype: 'textfield',
                    name: 'oldpassword',
                    fieldLabel: 'Password',
                    inputType: 'password'
                }, {
                    xtype: 'textfield',
                    name: 'newpassword',
                    id: 'newpassword',
                    fieldLabel: 'New password',
                    inputType: 'password'
                }, {
                    xtype: 'textfield',
                    name: 'newpassword2',
                    fieldLabel: 'Verify new password',
                    inputType: 'password',
                    vtype: 'password', // see inc/extensions.js
                    initialPassField: 'newpassword' // id of the initial password field
                }, {
                    xtype: 'button',
                    text: 'Change password',
                    handler: this.saveSettings,
                    scope: this
                }]
            }]
        };
        
        Ext.applyIf(this, cfg);
        Ext.applyIf(this.initialConfig, cfg);
        
        //non-alterable configurables 
        cfg = {};
        Ext.apply(this, cfg);
        Ext.apply(this.initialConfig, cfg);
        
        App.ux.FormPanelChangePassword.superclass.initComponent.apply(this, arguments);
        
    }, // eo function initComponent 
    onRender: function(container, position)
    {
        App.ux.FormPanelChangePassword.superclass.onRender.apply(this, arguments);
        // after parent code
        // bind a few useful events to handle row selection, and context menu
        //this.on('contextmenu', this.showContextMenu, this);
        // general buttons
    },
    saveSettings: function()
    {	
        this.getForm().submit({
            url: '../../xml/auth?action=password',
            method: 'GET',
            scope: this,
            customSuccessFn: function(xml,scope)
            {
                var f = scope.getForm();               
                    f.reset();
                    App.showMessage('Password was changed successfully.');
					return true;
            },
            failure: function(){
				App.showError('Password could not be changed. Please correct your data.');
				return false;
			}
        });
		
		if(this.getForm().isValid!==true)
		{
					return false;
    		
		}
		
		
    }
});
/*
 * Register xtype
 */
Ext.ComponentMgr.registerType('ux-formpanelchangepassword', App.ux.FormPanelChangePassword); //convention is to use all lowercase for xtype
